/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal;

public final class RWTProperties {
    public static final String USE_VERSIONED_JAVA_SCRIPT = "org.eclipse.rap.useVersionedJavaScript";
    public static final String USE_COMPRESSED_JAVA_SCRIPT = "org.eclipse.rap.useCompressedJavaScript";
    public static final String CLIENT_LIBRARY_VARIANT = "org.eclipse.rwt.clientLibraryVariant";
    public static final String DEBUG_CLIENT_LIBRARY_VARIANT = "DEBUG";
    public static final String ENABLE_THEME_WARNINGS = "org.eclipse.rap.enableThemeWarnings";
    public static final String ENABLE_UI_TESTS = "org.eclipse.rap.rwt.enableUITests";

    private RWTProperties() {
    }

    public static boolean useVersionedJavaScript() {
        return RWTProperties.getBooleanProperty(USE_VERSIONED_JAVA_SCRIPT, true);
    }

    public static boolean useCompressedJavaScript() {
        return RWTProperties.getBooleanProperty(USE_COMPRESSED_JAVA_SCRIPT, true);
    }

    public static boolean enableThemeDebugOutput() {
        return RWTProperties.getBooleanProperty(ENABLE_THEME_WARNINGS, false);
    }

    public static boolean isDevelopmentMode() {
        String libraryVariant = System.getProperty(CLIENT_LIBRARY_VARIANT);
        return DEBUG_CLIENT_LIBRARY_VARIANT.equals(libraryVariant);
    }

    private static boolean getBooleanProperty(String key, boolean defaultValue) {
        boolean result = defaultValue;
        String propertyValue = System.getProperty(key);
        if (propertyValue != null) {
            result = propertyValue.equalsIgnoreCase("true");
        }
        return result;
    }
}

