/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.scrollbarkit.ScrollBarThemeAdapter;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    private final Scrollable parent;
    private int thumb;
    private int selection;
    private int minimum;
    private int maximum;

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public void setVisible(boolean visible) {
        boolean isVisible;
        this.checkWidget();
        boolean bl = isVisible = (this.state & 0x10) == 0;
        if (isVisible != visible) {
            this.state = visible ? this.state & 0xFFFFFFEF : this.state | 0x10;
        }
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public Point getSize() {
        Point result = this.parent.getSize();
        if ((this.style & 0x100) != 0) {
            result.y = this.getScrollBarWidth();
        } else {
            result.x = this.getScrollBarWidth();
        }
        return result;
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public void setThumb(int thumb) {
        this.checkWidget();
        this.thumb = thumb;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        this.maximum = maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.checkWidget();
        this.minimum = minimum;
    }

    public void setSelection(int selection) {
        this.checkWidget();
        if (this.selection != selection) {
            this.selection = selection;
        }
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    private static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    private int getScrollBarWidth() {
        ScrollBarThemeAdapter themeAdapter = (ScrollBarThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return themeAdapter.getScrollBarWidth(this);
    }
}

