/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ITreeItemAdapter;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeItem
extends Item {
    private final TreeItem parentItem;
    final Tree parent;
    TreeItem[] items;
    int itemCount;
    private transient ITreeItemAdapter treeItemAdapter;
    int index;
    private Data[] data;
    private Font font;
    private boolean expanded;
    private boolean checked;
    private Color background;
    private Color foreground;
    private boolean grayed;
    int depth;
    private boolean cached;
    private int flatIndex;

    public TreeItem(Tree parent, int style) {
        this(parent, null, style, parent == null ? 0 : parent.getItemCount(), true);
    }

    public TreeItem(Tree parent, int style, int index) {
        this(parent, null, style, index, true);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(parentItem == null ? null : parentItem.parent, parentItem, style, parentItem == null ? 0 : parentItem.itemCount, true);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(parentItem == null ? null : parentItem.parent, parentItem, style, index, true);
    }

    TreeItem(Tree parent, TreeItem parentItem, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        this.parentItem = parentItem;
        this.index = index;
        if (parentItem != null) {
            this.depth = parentItem.depth + 1;
        }
        parent.isFlatIndexValid = false;
        this.setEmpty();
        if (create) {
            int numberOfItems = parentItem != null ? parentItem.itemCount : parent.getItemCount();
            if (index < 0 || index > numberOfItems) {
                this.error(6);
            }
            if (parentItem != null) {
                parentItem.createItem(this, index);
            } else {
                parent.createItem(this, index);
            }
            parent.updateScrollBars();
        }
    }

    private void setEmpty() {
        this.items = new TreeItem[4];
    }

    private void createItem(TreeItem item, int index) {
        if (this.itemCount == this.items.length) {
            boolean small = this.isVisible();
            int length = small ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TreeItem[] newItems = new TreeItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
        this.adjustItemIndices(index);
    }

    private void destroyItem(TreeItem item, int index) {
        --this.itemCount;
        if (this.itemCount == 0) {
            this.setEmpty();
        } else {
            System.arraycopy(this.items, index + 1, this.items, index, this.itemCount - index);
            this.items[this.itemCount] = null;
        }
        this.adjustItemIndices(index);
    }

    private void adjustItemIndices(int start) {
        int i = start;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].index = i;
            }
            ++i;
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IItemHolderAdapter.class) {
            result = new CompositeItemHolder();
        } else if (adapter == IWidgetFontAdapter.class || adapter == IWidgetColorAdapter.class || adapter == ITreeItemAdapter.class) {
            if (this.treeItemAdapter == null) {
                this.treeItemAdapter = new TreeItemAdapter();
            }
            result = this.treeItemAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return (T)result;
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        if (!(this.expanded == expanded || expanded && this.itemCount <= 0)) {
            this.expanded = expanded;
            if (!expanded) {
                this.updateSelection();
            }
            this.markCached();
            this.parent.updateScrollBars();
            this.parent.updateAllItems();
        }
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public Rectangle getBounds() {
        return this.getBounds(0);
    }

    public Rectangle getBounds(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        Rectangle result = new Rectangle(0, 0, 0, 0);
        if (this.isVisible() && this.isValidColumn(columnIndex)) {
            int left = this.parent.getVisualCellLeft(columnIndex, this);
            int width = this.parent.getVisualCellWidth(columnIndex, this);
            result = new Rectangle(left, this.getItemTop(), width, this.parent.getItemHeight());
        }
        return result;
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        Color result = this.hasData(index) && this.data[index].background != null ? this.data[index].background : (this.background == null ? this.parent.getBackground() : this.background);
        return result;
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        Font result = this.hasData(index) && this.data[index].font != null ? this.data[index].font : (this.font == null ? this.parent.getFont() : this.font);
        return result;
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        Color result = this.hasData(index) && this.data[index].foreground != null ? this.data[index].foreground : (this.foreground == null ? this.parent.getForeground() : this.foreground);
        return result;
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index >= 0 && index < count) {
            this.ensureData(index, count);
            if (!TreeItem.equals(this.data[index].background, color)) {
                this.data[index].background = color;
                this.markCached();
                this.parent.redraw();
            }
        }
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index >= 0 && index < count) {
            this.ensureData(index, count);
            if (!TreeItem.equals(font, this.data[index].font)) {
                this.data[index].font = font;
                this.data[index].preferredWidthBuffer = -1;
                this.markCached();
                this.parent.redraw();
            }
        }
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index >= 0 && index < count) {
            this.ensureData(index, count);
            if (!TreeItem.equals(this.data[index].foreground, color)) {
                this.data[index].foreground = color;
                this.markCached();
                this.parent.redraw();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if (!TreeItem.equals(this.font, font)) {
            this.font = font;
            this.markCached();
            if (this.parent.getColumnCount() == 0) {
                this.parent.updateScrollBars();
            }
            this.parent.redraw();
        }
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        Font result = this.font == null ? this.parent.getFont() : this.font;
        return result;
    }

    public void setBackground(Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        if (!TreeItem.equals(this.background, value)) {
            this.background = value;
            this.markCached();
        }
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        Color result = this.background == null ? this.parent.getBackground() : this.background;
        return result;
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        Color result = this.foreground == null ? this.parent.getForeground() : this.foreground;
        return result;
    }

    public void setForeground(Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        if (!TreeItem.equals(this.foreground, value)) {
            this.foreground = value;
            this.markCached();
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) != 0 && this.checked != checked) {
            this.checked = checked;
            this.markCached();
        }
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        return this.checked;
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) != 0 && this.grayed != grayed) {
            this.grayed = grayed;
            this.markCached();
        }
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        return this.grayed;
    }

    @Override
    public String getText() {
        this.checkWidget();
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        return this.getTextWithoutMaterialize(index);
    }

    String getTextWithoutMaterialize(int index) {
        String result = "";
        if (this.hasData(index)) {
            result = this.data[index].text;
        }
        return result;
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        Rectangle result = new Rectangle(0, 0, 0, 0);
        if (this.isVisible() && this.isValidColumn(index)) {
            result.x = this.parent.getVisualTextLeft(index, this);
            result.y = this.getItemTop();
            result.width = this.parent.getVisualTextWidth(index, this);
            result.height = this.parent.getItemHeight();
        }
        return result;
    }

    public void setText(String[] value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                this.setText(i, value[i]);
            }
            ++i;
        }
    }

    @Override
    public void setText(String text) {
        this.checkWidget();
        this.setText(0, text);
    }

    public void setText(int index, String text) {
        this.checkWidget();
        if (text == null) {
            this.error(4);
        }
        if (this.parent.markupEnabled && !this.parent.markupValidationDisabled) {
            MarkupValidator.getInstance().validate(text);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index >= 0 && index < count) {
            this.ensureData(index, count);
            if (!text.equals(this.data[index].text)) {
                this.data[index].text = text;
                this.data[index].preferredWidthBuffer = -1;
                this.markCached();
                if (this.parent.getColumnCount() == 0) {
                    this.parent.updateScrollBars();
                }
                this.parent.redraw();
            }
        }
    }

    @Override
    public Image getImage() {
        this.checkWidget();
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        Image result = null;
        if (this.hasData(index)) {
            result = this.data[index].image;
        }
        return result;
    }

    public Rectangle getImageBounds(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        Rectangle result = null;
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex >= 0 && columnIndex < validColumnCount) {
            result = new Rectangle(0, 0, 0, 0);
            Point size = this.parent.getItemImageSize(columnIndex);
            result.width = size.x;
            result.height = size.y;
            result.x = this.parent.getVisualCellLeft(columnIndex, this);
            if (!this.parent.isTreeColumn(columnIndex)) {
                result.x += this.parent.getCellPadding().x;
            }
            result.y = this.getItemTop();
        } else {
            result = new Rectangle(0, 0, 0, 0);
        }
        return result;
    }

    int getPreferredWidth(int columnIndex, boolean checkData) {
        return this.parent.getPreferredCellWidth(this, columnIndex, checkData);
    }

    void clear() {
        this.data = null;
        this.checked = false;
        this.grayed = false;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.clearCached();
        this.parent.updateScrollBars();
    }

    public void clear(int index, boolean recursive) {
        TreeItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.clear();
            if (recursive) {
                item.clearAll(true, false);
            }
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index >= 0 && index < count) {
            this.ensureData(index, count);
            if (!TreeItem.equals(this.data[index].image, image)) {
                this.parent.updateColumnImageCount(index, this.data[index].image, image);
                this.data[index].image = image;
                this.data[index].preferredWidthBuffer = -1;
                this.parent.updateItemImageSize(image);
                this.markCached();
                if (this.parent.getColumnCount() == 0) {
                    this.parent.updateScrollBars();
                }
                this.parent.redraw();
            }
        }
    }

    public void setImage(Image[] value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int i = 0;
        while (i < value.length) {
            if (value[i] != null && value[i].isDisposed()) {
                this.error(5);
            }
            ++i;
        }
        i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                this.setImage(i, value[i]);
            }
            ++i;
        }
    }

    public void clearAll(boolean recursive) {
        this.clearAll(recursive, true);
    }

    void clearAll(boolean recursive, boolean doVisualUpdate) {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.clear();
                if (recursive) {
                    item.clearAll(true, false);
                }
                this.parent.checkData(item, item.index);
            }
            ++i;
        }
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.itemCount];
        if (this.parent.isVirtual()) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    TreeItem _getItem(int index) {
        if (this.parent.isVirtual() && this.items[index] == null) {
            this.items[index] = new TreeItem(this.parent, this, 0, index, false);
        }
        return this.items[index];
    }

    TreeItem[] getCreatedItems() {
        TreeItem[] result;
        if (this.parent.isVirtual()) {
            int count = 0;
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null && this.items[i].isCached()) {
                    ++count;
                }
                ++i;
            }
            result = new TreeItem[count];
            count = 0;
            i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null && this.items[i].isCached()) {
                    result[count] = this.items[i];
                    ++count;
                }
                ++i;
            }
        } else {
            result = new TreeItem[this.itemCount];
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        return this._getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.index)) {
            this.error(24);
        }
        return this.itemCount;
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        return item.parentItem == this ? item.index : -1;
    }

    public void removeAll() {
        this.checkWidget();
        int i = this.itemCount - 1;
        while (i >= 0) {
            if (this.items[i] != null) {
                this.items[i].dispose();
            } else {
                --this.itemCount;
            }
            --i;
        }
        this.setEmpty();
    }

    public void setItemCount(int count) {
        this.checkWidget();
        int oldItemCount = this.itemCount;
        int newItemCount = Math.max(0, count);
        if (newItemCount != oldItemCount) {
            int index = oldItemCount - 1;
            while (index >= newItemCount) {
                TreeItem item = this.items[index];
                if (item != null && !item.isDisposed()) {
                    item.dispose();
                }
                --index;
            }
            int length = Math.max(4, (newItemCount + 3) / 4 * 4);
            TreeItem[] newItems = new TreeItem[length];
            System.arraycopy(this.items, 0, newItems, 0, Math.min(newItemCount, this.itemCount));
            this.items = newItems;
            if (!this.parent.isVirtual()) {
                int i = oldItemCount;
                while (i < newItemCount) {
                    new TreeItem(this, 0, i);
                    ++i;
                }
            }
            this.itemCount = newItemCount;
            this.parent.isFlatIndexValid = false;
            this.parent.updateScrollBars();
            this.parent.redraw();
        }
    }

    @Override
    final void releaseChildren() {
        int i = this.items.length - 1;
        while (i >= 0) {
            if (this.items[i] != null) {
                this.items[i].dispose();
            }
            --i;
        }
    }

    @Override
    final void releaseParent() {
        if (this.parentItem != null) {
            this.parentItem.destroyItem(this, this.index);
        } else {
            this.parent.destroyItem(this, this.index);
        }
        if (!this.parent.isInDispose()) {
            this.parent.isFlatIndexValid = false;
            this.parent.removeFromSelection(this);
            this.parent.updateScrollBars();
        }
        super.releaseParent();
    }

    private boolean isValidColumn(int index) {
        int columnCount = this.parent.getColumnCount();
        return columnCount == 0 && index == 0 || index >= 0 && index < columnCount;
    }

    private boolean isVisible() {
        return this.getParentItem() == null || this.getParentItem().getExpanded();
    }

    int getItemTop() {
        int headerHeight = this.parent.getHeaderHeight();
        int itemHeight = this.parent.getItemHeight();
        return headerHeight + (this.getFlatIndex() - this.parent.getTopItemIndex()) * itemHeight;
    }

    int getFlatIndex() {
        if (!this.parent.isFlatIndexValid) {
            this.parent.updateAllItems();
        }
        return this.flatIndex;
    }

    void setFlatIndex(int flatIndex) {
        this.flatIndex = flatIndex;
    }

    boolean hasPreferredWidthBuffer(int index) {
        return this.getPreferredWidthBuffer(index) != -1;
    }

    int getPreferredWidthBuffer(int index) {
        int result = -1;
        if (this.hasData(index)) {
            result = this.data[index].preferredWidthBuffer;
        }
        return result;
    }

    void setPreferredWidthBuffer(int index, int preferredWidthBuffer) {
        int count = Math.max(1, this.parent.getColumnCount());
        this.ensureData(index, count);
        this.data[index].preferredWidthBuffer = preferredWidthBuffer;
    }

    void clearPreferredWidthBuffers() {
        int count = Math.max(1, this.parent.getColumnCount());
        int i = 0;
        while (i < count) {
            if (this.hasData(i)) {
                this.data[i].preferredWidthBuffer = -1;
            }
            ++i;
        }
    }

    int getInnerHeight() {
        int innerHeight = this.itemCount * this.parent.getItemHeight();
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null && item.getExpanded()) {
                innerHeight += item.getInnerHeight();
            }
            ++i;
        }
        return innerHeight;
    }

    void markCached() {
        if (this.parent.isVirtual()) {
            this.cached = true;
        }
    }

    private void clearCached() {
        if (this.parent.isVirtual()) {
            this.cached = false;
        }
    }

    boolean isCached() {
        boolean result = true;
        if (this.parent.isVirtual()) {
            result = this.cached;
        }
        return result;
    }

    private static boolean equals(Object object1, Object object2) {
        boolean result = object1 == object2 ? true : (object1 == null ? false : object1.equals(object2));
        return result;
    }

    private void ensureData(int index, int columnCount) {
        if (this.data == null) {
            this.data = new Data[columnCount];
        } else if (this.data.length < columnCount) {
            Data[] newData = new Data[columnCount];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        if (this.data[index] == null) {
            this.data[index] = new Data();
        }
    }

    private boolean hasData(int index) {
        return this.data != null && index >= 0 && index < this.data.length && this.data[index] != null;
    }

    final void shiftData(int index) {
        if (this.data != null && this.data.length > index && this.parent.getColumnCount() > 1) {
            Data[] newData = new Data[this.data.length + 1];
            System.arraycopy(this.data, 0, newData, 0, index);
            int offSet = this.data.length - index;
            System.arraycopy(this.data, index, newData, index + 1, offSet);
            this.data = newData;
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].shiftData(index);
            }
            ++i;
        }
    }

    final void removeData(int index) {
        if (this.data != null && this.data.length > index && this.parent.getColumnCount() > 1) {
            Data[] newData = new Data[this.data.length - 1];
            System.arraycopy(this.data, 0, newData, 0, index);
            int offSet = this.data.length - index - 1;
            System.arraycopy(this.data, index + 1, newData, index, offSet);
            this.data = newData;
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].removeData(index);
            }
            ++i;
        }
    }

    private void updateSelection() {
        TreeItem[] selection = this.parent.getSelection();
        ArrayList<TreeItem> selectedItems = new ArrayList<TreeItem>(Arrays.asList(selection));
        if (this.deselectChildren(selectedItems)) {
            if ((this.parent.getStyle() & 4) != 0) {
                selectedItems.add(this);
            }
            this.parent.setSelection(selectedItems.toArray(new TreeItem[0]));
        }
    }

    boolean deselectChildren(List<TreeItem> selectedItems) {
        boolean result = false;
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null) {
                if (selectedItems.contains(item)) {
                    selectedItems.remove(item);
                    result = true;
                }
                if (item.deselectChildren(selectedItems)) {
                    result = true;
                }
            }
            ++i;
        }
        return result;
    }

    private final class CompositeItemHolder
    implements IItemHolderAdapter {
        private CompositeItemHolder() {
        }

        public void add(Item item) {
            throw new UnsupportedOperationException();
        }

        public void insert(Item item, int index) {
            throw new UnsupportedOperationException();
        }

        public void remove(Item item) {
            throw new UnsupportedOperationException();
        }

        public Item[] getItems() {
            TreeItem[] items = TreeItem.this.getCreatedItems();
            Item[] result = new Item[items.length];
            System.arraycopy(items, 0, result, 0, items.length);
            return result;
        }
    }

    private static final class Data
    implements SerializableCompatibility {
        static final int UNKNOWN_WIDTH = -1;
        String text = "";
        int preferredWidthBuffer = -1;
        Image image;
        Font font;
        Color background;
        Color foreground;

        private Data() {
        }
    }

    private final class TreeItemAdapter
    implements ITreeItemAdapter,
    IWidgetFontAdapter,
    IWidgetColorAdapter {
        private TreeItemAdapter() {
        }

        public boolean isParentDisposed() {
            Widget itemParent = TreeItem.this.parentItem == null ? TreeItem.this.parent : TreeItem.this.parentItem;
            return itemParent.isDisposed();
        }

        public Color getUserBackground() {
            return TreeItem.this.background;
        }

        public Color getUserForeground() {
            return TreeItem.this.foreground;
        }

        public Font getUserFont() {
            return TreeItem.this.font;
        }

        public Color[] getCellBackgrounds() {
            int columnCount = Math.max(1, TreeItem.this.getParent().getColumnCount());
            Color[] result = new Color[columnCount];
            if (TreeItem.this.data != null) {
                int i = 0;
                while (i < TreeItem.this.data.length) {
                    if (TreeItem.this.data[i] != null) {
                        result[i] = ((TreeItem)TreeItem.this).data[i].background;
                    }
                    ++i;
                }
            }
            return result;
        }

        public Color[] getCellForegrounds() {
            int columnCount = Math.max(1, TreeItem.this.getParent().getColumnCount());
            Color[] result = new Color[columnCount];
            if (TreeItem.this.data != null) {
                int i = 0;
                while (i < TreeItem.this.data.length) {
                    if (TreeItem.this.data[i] != null) {
                        result[i] = ((TreeItem)TreeItem.this).data[i].foreground;
                    }
                    ++i;
                }
            }
            return result;
        }

        public Font[] getCellFonts() {
            int columnCount = Math.max(1, TreeItem.this.getParent().getColumnCount());
            Font[] result = new Font[columnCount];
            if (TreeItem.this.data != null) {
                int i = 0;
                while (i < TreeItem.this.data.length) {
                    if (TreeItem.this.data[i] != null) {
                        result[i] = ((TreeItem)TreeItem.this).data[i].font;
                    }
                    ++i;
                }
            }
            return result;
        }
    }
}

