/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.rest.provider.internal.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.rtp.core.model.Source;
import org.eclipse.rtp.core.model.SourceVersion;
import org.eclipse.rtp.core.util.ModelUtil;

public class PathInfoUtil {
    public SourceVersion getSourceVersion(String pathInfo, ModelUtil modelUtil, List<Source> sources) {
        String sourceName = this.getSourceName(pathInfo);
        List searchSources = modelUtil.searchSources(Arrays.asList(sourceName), sources);
        String sourceVersion = this.getSourceVersion(pathInfo);
        SourceVersion searchSourceVerions = modelUtil.searchSourceVerions(sourceVersion, searchSources);
        return searchSourceVerions;
    }

    public String getSourceVersion(String pathInfo) {
        String[] provisioningInfo = this.getProvisioningInfo(pathInfo);
        String result = provisioningInfo.length >= 3 ? provisioningInfo[2] : "";
        return result;
    }

    public String getSourceName(String pathInfo) {
        String[] provisioningInfo = this.getProvisioningInfo(pathInfo);
        return provisioningInfo[1];
    }

    public boolean isProvisioning(String pathInfo, ModelUtil modelUtil, List<Source> sources) {
        boolean result = false;
        String[] provisioningInfo = this.getProvisioningInfo(pathInfo);
        if (provisioningInfo.length != 0 && this.isProvisionigCommand(provisioningInfo[0])) {
            List<String> sourceQuery = Arrays.asList(provisioningInfo[1]);
            List searchResult = modelUtil.searchSources(sourceQuery, sources);
            result = !searchResult.isEmpty();
        }
        return result;
    }

    private boolean isProvisionigCommand(String provisioningCommand) {
        return "install".equalsIgnoreCase(provisioningCommand) || "uninstall".equalsIgnoreCase(provisioningCommand);
    }

    public String[] getProvisioningInfo(String pathInfo) {
        Path path;
        String[] provisioningInfo = new String[]{};
        if (pathInfo != null && pathInfo.length() > 0 && (path = new Path(pathInfo)).segmentCount() >= 2) {
            provisioningInfo = path.segments();
        }
        return provisioningInfo;
    }

    public String[] splitPathInfo(String pathInfo) {
        String[] result = new String[]{};
        if (pathInfo != null && pathInfo.length() > 0) {
            result = new Path(pathInfo).segments();
        }
        return result;
    }
}

