/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceHandlerRegistry;
import org.eclipse.rap.rwt.service.IServiceHandler;
import org.eclipse.rap.rwt.service.IServiceManager;

public class ServiceManager
implements IServiceManager {
    private final IServiceHandler lifeCycleRequestHandler;
    private final ServiceHandlerRegistry customHandlers;

    public ServiceManager(IServiceHandler lifeCycleRequestHandler) {
        this.lifeCycleRequestHandler = lifeCycleRequestHandler;
        this.customHandlers = new ServiceHandlerRegistry();
    }

    public IServiceHandler getServiceHandler(String customId) {
        return this.customHandlers.get(customId);
    }

    public void registerServiceHandler(String id, IServiceHandler handler) {
        this.customHandlers.put(id, handler);
    }

    public void unregisterServiceHandler(String id) {
        this.customHandlers.remove(id);
    }

    public void clear() {
        this.customHandlers.clear();
    }

    public IServiceHandler getHandler() {
        String customId = ServiceManager.getCustomHandlerId();
        IServiceHandler result = customId != null && customId.length() > 0 ? this.getCustomHandlerChecked(customId) : this.lifeCycleRequestHandler;
        return result;
    }

    private IServiceHandler getCustomHandlerChecked(String customId) {
        IServiceHandler customHandler = this.customHandlers.get(customId);
        if (customHandler == null) {
            throw new IllegalArgumentException("No service handler registered with id " + customId);
        }
        return customHandler;
    }

    private static String getCustomHandlerId() {
        return ContextProvider.getRequest().getParameter("custom_service_handler");
    }
}

