/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rap.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rap.rwt.internal.theme.JsonArray;
import org.eclipse.rap.rwt.internal.theme.JsonObject;
import org.eclipse.rap.rwt.internal.theme.JsonValue;
import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.rap.rwt.internal.theme.Theme;
import org.eclipse.rap.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rap.rwt.internal.theme.ThemePropertyAdapterRegistry;
import org.eclipse.rap.rwt.internal.theme.css.ConditionalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThemeStoreWriter {
    private final IThemeCssElement[] allThemeableWidgetElements;
    private final Theme theme;

    public ThemeStoreWriter(Theme theme, IThemeCssElement[] elements) {
        this.theme = theme;
        this.allThemeableWidgetElements = elements;
    }

    public String createJson() {
        QxType[] allValues = this.theme.getValuesMap().getAllValues();
        Map valuesMap = ThemeStoreWriter.createValuesMap(allValues);
        JsonObject json = new JsonObject();
        json.append("values", ThemeStoreWriter.createJsonFromValuesMap(valuesMap));
        json.append("theme", this.createThemeJson());
        return json.toString();
    }

    private JsonObject createThemeJson() {
        JsonObject result = new JsonObject();
        ThemeCssValuesMap valuesMap = this.theme.getValuesMap();
        int i = 0;
        while (i < this.allThemeableWidgetElements.length) {
            IThemeCssElement element = this.allThemeableWidgetElements[i];
            String elementName = element.getName();
            JsonObject elementObj = this.createThemeJsonForElement(valuesMap, element);
            result.append(elementName, elementObj);
            ++i;
        }
        return result;
    }

    private JsonObject createThemeJsonForElement(ThemeCssValuesMap valuesMap, IThemeCssElement element) {
        JsonObject result = new JsonObject();
        String[] properties = element.getProperties();
        ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance();
        int i = 0;
        while (i < properties.length) {
            String propertyName = properties[i];
            JsonArray valuesArray = new JsonArray();
            String elementName = element.getName();
            ConditionalValue[] values = valuesMap.getValues(elementName, propertyName);
            int j = 0;
            while (j < values.length) {
                ConditionalValue conditionalValue = values[j];
                JsonArray array = new JsonArray();
                array.append(JsonArray.valueOf(conditionalValue.constraints));
                QxType value = conditionalValue.value;
                ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(value.getClass());
                String cssKey = adapter.getKey(value);
                array.append(cssKey);
                valuesArray.append(array);
                ++j;
            }
            result.append(propertyName, valuesArray);
            ++i;
        }
        return result;
    }

    private static Map createValuesMap(QxType[] values) {
        LinkedHashMap<String, JsonObject> result = new LinkedHashMap<String, JsonObject>();
        int i = 0;
        while (i < values.length) {
            ThemeStoreWriter.appendValueToMap(values[i], result);
            ++i;
        }
        return result;
    }

    private static void appendValueToMap(QxType propertyValue, Map<String, JsonObject> valuesMap) {
        String slot;
        ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance();
        ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(propertyValue.getClass());
        if (adapter != null && (slot = adapter.getSlot(propertyValue)) != null) {
            String key = adapter.getKey(propertyValue);
            JsonValue value = adapter.getValue(propertyValue);
            if (value != null) {
                JsonObject slotObject = ThemeStoreWriter.getSlot(valuesMap, slot);
                slotObject.append(key, value);
            }
        }
    }

    private static JsonValue createJsonFromValuesMap(Map valuesMap) {
        JsonObject result = new JsonObject();
        Set entrySet = valuesMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            JsonValue value = (JsonValue)entry.getValue();
            result.append(key, value);
        }
        return result;
    }

    private static JsonObject getSlot(Map<String, JsonObject> valuesMap, String name) {
        JsonObject result = valuesMap.get(name);
        if (result == null) {
            result = new JsonObject();
            valuesMap.put(name, result);
        }
        return result;
    }
}

