/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

final class MenuItemLCAUtil {
    private static final String TYPE = "rwt.widgets.MenuItem";
    private static final String[] ALLOWED_STYLES = new String[]{"CHECK", "CASCADE", "PUSH", "RADIO", "SEPARATOR"};
    private static final String PROP_MENU = "menu";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SELECTION_LISTENER = "Selection";

    MenuItemLCAUtil() {
    }

    static void preserveValues(MenuItem item) {
        WidgetLCAUtil.preserveCustomVariant(item);
        ItemLCAUtil.preserve(item);
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_MENU, item.getMenu());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_ENABLED, item.getEnabled());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_SELECTION, item.getSelection());
        WidgetLCAUtil.preserveListener(item, PROP_SELECTION_LISTENER, item.isListening(13));
        WidgetLCAUtil.preserveHelpListener(item);
    }

    static void renderInitialization(MenuItem item) {
        IClientObject clientObject = ClientObjectFactory.getClientObject(item);
        clientObject.create(TYPE);
        Menu parent = item.getParent();
        clientObject.set("parent", WidgetUtil.getId(parent));
        clientObject.set("style", WidgetLCAUtil.getStyles(item, ALLOWED_STYLES));
        clientObject.set("index", parent.indexOf(item));
    }

    static void renderChanges(MenuItem item) {
        WidgetLCAUtil.renderCustomVariant(item);
        ItemLCAUtil.renderChanges(item);
        WidgetLCAUtil.renderMenu(item, item.getMenu());
        WidgetLCAUtil.renderProperty((Widget)item, PROP_ENABLED, item.getEnabled(), true);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_SELECTION, item.getSelection(), false);
        WidgetLCAUtil.renderListener(item, PROP_SELECTION_LISTENER, item.isListening(13), false);
        WidgetLCAUtil.renderListenHelp(item);
    }

    static void processArmEvent(MenuItem item) {
        Menu menu = item.getParent();
        if (WidgetLCAUtil.wasEventSent(menu, "Show")) {
            item.notifyListeners(30, new Event());
        }
    }
}

