/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.application;

import org.eclipse.rap.rwt.internal.application.ApplicationContext;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.swt.internal.widgets.displaykit.ClientResources;

public class ApplicationContextActivator {
    public static boolean skipResoureRegistration;
    public static boolean skipResoureDeletion;
    private final ApplicationContext applicationContext;

    ApplicationContextActivator(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    void activate() {
        ApplicationContextUtil.runWith(this.applicationContext, new Runnable(){

            public void run() {
                ApplicationContextActivator.this.activateInstances();
            }
        });
    }

    private void activateInstances() {
        this.applicationContext.getStartupPage().activate();
        this.applicationContext.getLifeCycleFactory().activate();
        this.applicationContext.getJSLibraryConcatenator().startJSConcatenation();
        this.applicationContext.getThemeManager().activate();
        if (!skipResoureRegistration) {
            new ClientResources(this.applicationContext.getResourceManager(), this.applicationContext.getThemeManager()).registerResources();
        }
        this.applicationContext.getResourceRegistry().registerResources();
        this.applicationContext.getJSLibraryConcatenator().activate();
        this.applicationContext.getClientSelector().activate();
    }

    void deactivate() {
        ApplicationContextUtil.runWith(this.applicationContext, new Runnable(){

            public void run() {
                ApplicationContextActivator.this.deactivateInstances();
            }
        });
    }

    private void deactivateInstances() {
        this.applicationContext.getStartupPage().deactivate();
        this.applicationContext.getJSLibraryConcatenator().deactivate();
        this.applicationContext.getLifeCycleFactory().deactivate();
        this.applicationContext.getServiceManager().clear();
        this.applicationContext.getThemeManager().deactivate();
        if (!skipResoureDeletion) {
            this.applicationContext.getResourceDirectory().deleteDirectory();
        }
    }
}

