/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import javax.servlet.http.Cookie;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.ISessionStore;
import org.eclipse.rap.rwt.service.ISettingStore;
import org.eclipse.rap.rwt.service.ISettingStoreFactory;

public class SettingStoreManager {
    private static final String COOKIE_NAME = "settingStore";
    private static final int COOKIE_MAX_AGE_SEC = 7776000;
    private static long last = System.currentTimeMillis();
    private static int instanceCount;
    private ISettingStoreFactory factory;

    public synchronized ISettingStore getStore() {
        String storeId;
        ISessionStore session = ContextProvider.getSessionStore();
        ISettingStore result = (ISettingStore)session.getAttribute(storeId = this.getStoreId());
        if (result == null) {
            result = this.factory.createSettingStore(storeId);
            session.setAttribute(storeId, result);
        }
        return result;
    }

    public synchronized void register(ISettingStoreFactory factory) {
        ParamCheck.notNull(factory, "factory");
        if (this.hasFactory()) {
            throw new IllegalStateException("There is already an ISettingStoreFactory registered.");
        }
        this.factory = factory;
    }

    public void deregisterFactory() {
        if (!this.hasFactory()) {
            throw new IllegalStateException("There is no ISettingStoreFactory for deregistration.");
        }
        this.factory = null;
    }

    public synchronized boolean hasFactory() {
        return this.factory != null;
    }

    private synchronized String createUniqueStoreId() {
        long now = System.currentTimeMillis();
        if (last == now) {
            ++instanceCount;
        } else {
            last = now;
            instanceCount = 0;
        }
        return String.valueOf(String.valueOf(now)) + "_" + String.valueOf(instanceCount);
    }

    private String getStoreId() {
        ISessionStore session = ContextProvider.getSessionStore();
        String result = (String)session.getAttribute(COOKIE_NAME);
        if (result == null) {
            result = this.getStoreIdFromCookie();
            if (result == null) {
                result = this.createUniqueStoreId();
            }
            Cookie cookie = new Cookie(COOKIE_NAME, result);
            cookie.setSecure(RWT.getRequest().isSecure());
            cookie.setMaxAge(7776000);
            ContextProvider.getResponse().addCookie(cookie);
            session.setAttribute(COOKIE_NAME, result);
        }
        return result;
    }

    private String getStoreIdFromCookie() {
        String result = null;
        Cookie[] cookies = ContextProvider.getRequest().getCookies();
        if (cookies != null) {
            int i = 0;
            while (result == null && i < cookies.length) {
                String value;
                Cookie cookie = cookies[i];
                if (COOKIE_NAME.equals(cookie.getName()) && SettingStoreManager.isValidCookieValue(value = cookie.getValue())) {
                    result = value;
                }
                ++i;
            }
        }
        return result;
    }

    static boolean isValidCookieValue(String value) {
        boolean result = false;
        int index = value.indexOf(95);
        if (index != -1) {
            try {
                Long.parseLong(value.substring(0, index));
                Integer.parseInt(value.substring(index + 1));
                result = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }
}

