/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.rap.rwt.internal.engine.PostDeserialization;
import org.eclipse.rap.rwt.internal.uicallback.UICallBackManager;
import org.eclipse.rap.rwt.service.ISessionStore;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

final class TimerExecScheduler
implements SerializableCompatibility {
    private final Display display;
    private final UICallBackManager uiCallBackManager;
    private final Collection<TimerExecTask> tasks;
    private transient Timer timer;

    TimerExecScheduler(Display display, UICallBackManager uiCallBackManager) {
        this.display = display;
        this.uiCallBackManager = uiCallBackManager;
        this.tasks = new LinkedList<TimerExecTask>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(int milliseconds, Runnable runnable) {
        TimerExecTask task = new TimerExecTask(runnable, milliseconds);
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            this.initializeTimer();
            this.tasks.add(task);
            this.timer.schedule((TimerTask)task, milliseconds);
        }
    }

    void cancel(Runnable runnable) {
        TimerExecTask task = this.removeTask(runnable);
        if (task != null) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.tasks.clear();
        }
    }

    private void initializeTimer() {
        if (this.timer == null) {
            this.timer = new Timer("RWT timerExec scheduler", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleTasks() {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            if (this.tasks.size() > 0) {
                this.initializeTimer();
                for (TimerExecTask task : this.tasks) {
                    this.timer.schedule((TimerTask)task, task.getTime());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerExecTask removeTask(Runnable runnable) {
        TimerExecTask result = null;
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            Iterator<TimerExecTask> iter = this.tasks.iterator();
            while (result == null && iter.hasNext()) {
                TimerExecTask task = iter.next();
                if (task.getRunnable() != runnable) continue;
                this.removeTask(result);
                result = task;
            }
        }
        return result;
    }

    private void removeTask(TimerTask task) {
        this.tasks.remove(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            stream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        stream.registerValidation(new PostDeserializationValidation(), 0);
    }

    private class PostDeserializationValidation
    implements ObjectInputValidation {
        private PostDeserializationValidation() {
        }

        public void validateObject() throws InvalidObjectException {
            ISessionStore sessionStore = this.getSessionStore();
            PostDeserialization.addProcessor(sessionStore, new Runnable(){

                public void run() {
                    TimerExecScheduler.this.rescheduleTasks();
                }
            });
        }

        private ISessionStore getSessionStore() {
            IDisplayAdapter adapter = TimerExecScheduler.this.display.getAdapter(IDisplayAdapter.class);
            return adapter.getSessionStore();
        }
    }

    private class TimerExecTask
    extends TimerTask
    implements SerializableCompatibility {
        private final Runnable runnable;
        private final Date time;

        TimerExecTask(Runnable runnable, long milliseconds) {
            this.runnable = runnable;
            this.time = new Date(System.currentTimeMillis() + milliseconds);
            TimerExecScheduler.this.uiCallBackManager.activateUICallBacksFor(this.getUICallBackId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = TimerExecScheduler.this.display.getDeviceLock();
            synchronized (object) {
                TimerExecScheduler.this.removeTask(this);
                if (!TimerExecScheduler.this.display.isDisposed()) {
                    TimerExecScheduler.this.display.asyncExec(this.runnable);
                }
            }
            TimerExecScheduler.this.uiCallBackManager.deactivateUICallBacksFor(this.getUICallBackId());
        }

        public boolean cancel() {
            TimerExecScheduler.this.uiCallBackManager.deactivateUICallBacksFor(this.getUICallBackId());
            return super.cancel();
        }

        Runnable getRunnable() {
            return this.runnable;
        }

        Date getTime() {
            return this.time;
        }

        private String getUICallBackId() {
            return String.valueOf(this.getClass().getName()) + "-" + System.identityHashCode(this);
        }
    }
}

