/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.events;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.events.TestElement;
import org.junit.Test;

public final class TestPropertyEvents
extends SapphireTestCase {
    private List<Event> monitor(TestElement element) {
        return this.monitor(element, null);
    }

    private List<Event> monitor(TestElement element, String path) {
        final ArrayList<Event> events = new ArrayList<Event>();
        Listener listener = new Listener(){

            public void handle(Event event) {
                events.add(event);
            }
        };
        if (path == null) {
            element.attach(listener);
            for (Property property : element.properties()) {
                property.attach(listener);
            }
        } else {
            element.attach(listener, path);
        }
        return events;
    }

    @Test
    public void testEventsValuePropertyPlain() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            List<Event> events = this.monitor(element);
            TestPropertyEvents.assertEquals((long)0L, (long)events.size());
            element.getValuePlain().text();
            element.setValuePlain("a");
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertValuePropertyContentEvent(events.get(0), element.getValuePlain(), null, "a");
            events.clear();
            element.getValuePlain().validation();
            element.setValuePlain("b");
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertValuePropertyContentEvent(events.get(0), element.getValuePlain(), "a", "b");
            events.clear();
            element.getValuePlain().enabled();
            element.setValuePlain("c");
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertValuePropertyContentEvent(events.get(0), element.getValuePlain(), "b", "c");
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testEventsValuePropertyConstrained() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            List<Event> events = this.monitor(element);
            TestPropertyEvents.assertEquals((long)0L, (long)events.size());
            element.getValueConstrained().text();
            element.setValueConstrained("a");
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertValuePropertyContentEvent(events.get(0), element.getValueConstrained(), null, "a");
            events.clear();
            element.getValueConstrained().validation();
            element.setValueConstrained("b");
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertValuePropertyContentEvent(events.get(0), element.getValueConstrained(), "a", "b");
            events.clear();
            element.setValueConstrained(null);
            TestPropertyEvents.assertEquals((long)2L, (long)events.size());
            TestPropertyEvents.assertValuePropertyContentEvent(events.get(0), element.getValueConstrained(), "b", null);
            TestPropertyEvents.assertPropertyValidationEvent(events.get(1), element.getValueConstrained(), Status.createOkStatus(), Status.createErrorStatus((String)"Value constrained must be specified"));
            events.clear();
            element.getValueConstrained().enabled();
            element.setValueConstrained("c");
            TestPropertyEvents.assertEquals((long)2L, (long)events.size());
            TestPropertyEvents.assertValuePropertyContentEvent(events.get(0), element.getValueConstrained(), null, "c");
            TestPropertyEvents.assertPropertyValidationEvent(events.get(1), element.getValueConstrained(), Status.createErrorStatus((String)"Value constrained must be specified"), Status.createOkStatus());
            events.clear();
            element.setEnablement(false);
            TestPropertyEvents.assertEquals((long)2L, (long)events.size());
            TestPropertyEvents.assertValuePropertyContentEvent(events.get(0), element.getEnablement(), null, "false");
            TestPropertyEvents.assertPropertyEnablementEvent(events.get(1), element.getValueConstrained(), true, false);
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testEventsListPropertyDescendents() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            List<Event> events = this.monitor(element, "List/*");
            TestPropertyEvents.assertEquals((long)0L, (long)events.size());
            TestElement.ListEntry a = (TestElement.ListEntry)element.getList().insert();
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), element.getList());
            events.clear();
            TestElement.ListEntry b = (TestElement.ListEntry)element.getList().insert();
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), element.getList());
            events.clear();
            a.setValue("abc");
            b.setValue("def");
            TestPropertyEvents.assertEquals((long)2L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), a.getValue());
            TestPropertyEvents.assertPropertyContentEvent(events.get(1), b.getValue());
            events.clear();
            element.getList().remove((Object)a);
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), element.getList());
            events.clear();
            TestElement.ListEntry ba = (TestElement.ListEntry)b.getChildren().insert();
            TestElement.ListEntry bb = (TestElement.ListEntry)b.getChildren().insert();
            TestPropertyEvents.assertEquals((long)2L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), b.getChildren());
            TestPropertyEvents.assertPropertyContentEvent(events.get(1), b.getChildren());
            events.clear();
            ba.setValue("ghi");
            bb.setValue("jkl");
            TestPropertyEvents.assertEquals((long)2L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), ba.getValue());
            TestPropertyEvents.assertPropertyContentEvent(events.get(1), bb.getValue());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testEventsListPropertyPath() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            List<Event> events = this.monitor(element, "List/Children/Value");
            TestPropertyEvents.assertEquals((long)0L, (long)events.size());
            TestElement.ListEntry a = (TestElement.ListEntry)element.getList().insert();
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), element.getList());
            events.clear();
            TestElement.ListEntry b = (TestElement.ListEntry)element.getList().insert();
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), element.getList());
            events.clear();
            a.setValue("abc");
            b.setValue("def");
            TestPropertyEvents.assertEquals((long)0L, (long)events.size());
            element.getList().remove((Object)a);
            TestPropertyEvents.assertEquals((long)1L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), element.getList());
            events.clear();
            TestElement.ListEntry ba = (TestElement.ListEntry)b.getChildren().insert();
            TestElement.ListEntry bb = (TestElement.ListEntry)b.getChildren().insert();
            TestPropertyEvents.assertEquals((long)2L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), b.getChildren());
            TestPropertyEvents.assertPropertyContentEvent(events.get(1), b.getChildren());
            events.clear();
            ba.setValue("ghi");
            bb.setValue("jkl");
            TestPropertyEvents.assertEquals((long)2L, (long)events.size());
            TestPropertyEvents.assertPropertyContentEvent(events.get(0), ba.getValue());
            TestPropertyEvents.assertPropertyContentEvent(events.get(1), bb.getValue());
        }
        finally {
            element.dispose();
        }
    }
}

