/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import java.util.List;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.swt.gef.internal.TraverseUtil;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DiagramTextCellEditor
extends TextCellEditor {
    private TextPart textPart;
    private DiagramNodePart nodePart;
    private SapphireDiagramEditorPagePart pagePart;
    private List<DiagramNodePart> sortedNodes = null;

    public DiagramTextCellEditor(TextPart textPart, Composite parent, int style) {
        super(parent, style);
        this.textPart = textPart;
        this.nodePart = (DiagramNodePart)textPart.nearest(DiagramNodePart.class);
        this.pagePart = (SapphireDiagramEditorPagePart)textPart.nearest(SapphireDiagramEditorPagePart.class);
    }

    protected Control createControl(Composite parent) {
        Text text = (Text)super.createControl(parent);
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    TextPart nextTextPart = TraverseUtil.getNextTextPartInSameNode(DiagramTextCellEditor.this.textPart);
                    if (nextTextPart == null) {
                        List sortedNodes = DiagramTextCellEditor.this.getSortedNodes();
                        nextTextPart = TraverseUtil.getTextPartInNextNode(sortedNodes, DiagramTextCellEditor.this.nodePart);
                    }
                    if (nextTextPart != null) {
                        DiagramTextCellEditor.this.pagePart.selectAndDirectEdit((ISapphirePart)nextTextPart);
                    }
                }
            }
        });
        return text;
    }

    private List<DiagramNodePart> getSortedNodes() {
        if (this.sortedNodes == null) {
            this.sortedNodes = TraverseUtil.getSortedNodeParts(this.pagePart);
        }
        return this.sortedNodes;
    }
}

