/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.presentation;

import org.eclipse.draw2d.IFigure;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.ImagePart;
import org.eclipse.sapphire.ui.diagram.editor.LinePart;
import org.eclipse.sapphire.ui.diagram.editor.RectanglePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeFactoryPart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.SpacerPart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.diagram.editor.ValidationMarkerPart;
import org.eclipse.sapphire.ui.diagram.shape.def.LayoutConstraintDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SelectionPresentation;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramNodePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ImagePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.LineShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.RectanglePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapeFactoryPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.SpacerPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.TextPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ValidationMarkerPresentation;

public class ShapePresentation
extends DiagramPresentation {
    private DiagramResourceCache resourceCache;
    private boolean separator = false;

    public ShapePresentation(DiagramPresentation parent, ShapePart shapePart, DiagramResourceCache resourceCache) {
        super((SapphirePart)shapePart, parent, parent.getConfigurationManager(), parent.shell());
        this.resourceCache = resourceCache;
    }

    public ShapePart part() {
        return (ShapePart)super.part();
    }

    public DiagramResourceCache getResourceCache() {
        return this.resourceCache;
    }

    @Override
    public DiagramPresentation parent() {
        return super.parent();
    }

    public SapphireDiagramEditor page() {
        return this.getConfigurationManager().getDiagramEditor();
    }

    public IFigure getParentFigure() {
        IFigure parentFigure = null;
        DiagramPresentation parentPresentation = this.parent();
        while (parentPresentation != null) {
            parentFigure = parentPresentation.getFigure();
            if (parentFigure != null) break;
            parentPresentation = parentPresentation.parent();
        }
        return parentFigure;
    }

    public IFigure getNodeFigure() {
        IFigure parentFigure = this.getFigure();
        DiagramPresentation parentPresentation = this.parent();
        while (!(parentPresentation instanceof DiagramNodePresentation)) {
            parentFigure = parentPresentation.getFigure();
            parentPresentation = parentPresentation.parent();
        }
        return parentFigure;
    }

    public LayoutConstraintDef getLayoutConstraint() {
        return this.part().getLayoutConstraint();
    }

    public boolean visible() {
        return this.part().visible();
    }

    public SelectionPresentation getSelectionPresentation() {
        return this.part().getSelectionPresentation();
    }

    @Override
    public void render() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
    }

    public void refreshVisuals() {
    }

    public boolean isSeparator() {
        return this.separator;
    }

    public void setSeparator(boolean separator) {
        this.separator = separator;
    }

    public static final class ShapePresentationFactory {
        public static ShapePresentation createShapePresentation(DiagramPresentation parent, ShapePart shapePart, DiagramResourceCache resourceCache) {
            ShapePresentation shapePresentation = null;
            if (shapePart instanceof TextPart) {
                shapePresentation = new TextPresentation(parent, (TextPart)shapePart, resourceCache);
            } else if (shapePart instanceof ImagePart) {
                shapePresentation = new ImagePresentation(parent, (ImagePart)shapePart, resourceCache);
            } else if (shapePart instanceof ValidationMarkerPart) {
                shapePresentation = new ValidationMarkerPresentation(parent, (ValidationMarkerPart)shapePart, resourceCache);
            } else if (shapePart instanceof LinePart) {
                shapePresentation = new LineShapePresentation(parent, (LinePart)shapePart, resourceCache);
            } else if (shapePart instanceof RectanglePart) {
                shapePresentation = new RectanglePresentation(parent, (RectanglePart)shapePart, resourceCache);
            } else if (shapePart instanceof ShapeFactoryPart) {
                shapePresentation = new ShapeFactoryPresentation(parent, (ShapeFactoryPart)shapePart, resourceCache);
            } else if (shapePart instanceof SpacerPart) {
                shapePresentation = new SpacerPresentation(parent, (SpacerPart)shapePart, resourceCache);
            }
            return shapePresentation;
        }
    }
}

