/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.util.Collections;
import java.util.Set;
import org.eclipse.help.IContext;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.forms.CompositePart;
import org.eclipse.sapphire.ui.forms.SectionDef;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.HelpSystem;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.SectionPresentation;
import org.eclipse.swt.widgets.Composite;

public class SectionPart
extends CompositePart {
    private FunctionResult titleFunctionResult;
    private FunctionResult descriptionFunctionResult;
    private boolean folded;

    @Override
    protected final void init() {
        super.init();
        SectionDef def = this.definition();
        this.titleFunctionResult = this.initExpression((Function)def.getLabel().content(), String.class, null, new Runnable(){

            @Override
            public void run() {
                SectionPart.this.broadcast((Event)new TitleEvent());
            }
        });
        this.descriptionFunctionResult = this.initExpression((Function)def.getDescription().content(), String.class, null, new Runnable(){

            @Override
            public void run() {
                SectionPart.this.broadcast((Event)new DescriptionEvent());
            }
        });
        this.folded = (Boolean)def.getCollapsedInitially().content();
    }

    @Override
    public final SectionDef definition() {
        return (SectionDef)super.definition();
    }

    public final String title() {
        return (String)this.titleFunctionResult.value();
    }

    public final String description() {
        return (String)this.descriptionFunctionResult.value();
    }

    public final boolean folded() {
        return this.folded;
    }

    public final void fold() {
        if (!this.folded) {
            this.folded = true;
            this.broadcast(new FoldingEvent());
        }
    }

    public final void unfold() {
        if (this.folded) {
            this.folded = false;
            this.broadcast(new FoldingEvent());
        }
    }

    @Override
    public final Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.Section");
    }

    @Override
    public final IContext getDocumentationContext() {
        ISapphireDocumentation doc = (ISapphireDocumentation)this.definition.getDocumentation().content();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                return HelpSystem.getContext(docdef);
            }
        }
        return null;
    }

    @Override
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        return new SectionPresentation(this, parent, composite);
    }

    public final class DescriptionEvent
    extends SapphirePart.PartEvent {
        public DescriptionEvent() {
            super(SectionPart.this);
        }

        @Override
        public SectionPart part() {
            return (SectionPart)super.part();
        }
    }

    public final class FoldingEvent
    extends SapphirePart.PartEvent {
        public FoldingEvent() {
            super(SectionPart.this);
        }

        @Override
        public SectionPart part() {
            return (SectionPart)super.part();
        }
    }

    public final class TitleEvent
    extends SapphirePart.PartEvent {
        public TitleEvent() {
            super(SectionPart.this);
        }

        @Override
        public SectionPart part() {
            return (SectionPart)super.part();
        }
    }
}

