/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.sapphire.modeling.ResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;

public class ByteArrayResourceStore
extends ResourceStore {
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private byte[] contents = EMPTY_BYTE_ARRAY;

    public ByteArrayResourceStore() {
    }

    public ByteArrayResourceStore(byte[] contents) {
        this.setContents(contents);
    }

    public ByteArrayResourceStore(String contents) {
        this.contents = contents.getBytes(StandardCharsets.UTF_8);
    }

    public ByteArrayResourceStore(InputStream in) throws ResourceStoreException {
        this.setContents(in);
    }

    public byte[] getContents() {
        int length = this.contents.length;
        byte[] copy = new byte[length];
        System.arraycopy(this.contents, 0, copy, 0, length);
        return copy;
    }

    public void setContents(byte[] contents) {
        if (contents == null) {
            throw new IllegalArgumentException();
        }
        int length = contents.length;
        byte[] copy = new byte[length];
        System.arraycopy(contents, 0, copy, 0, length);
        this.contents = copy;
    }

    public void setContents(InputStream in) throws ResourceStoreException {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        try {
            byte[] buffer = new byte[16384];
            int bufferUsedLength = 0;
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer, bufferUsedLength, buffer.length - bufferUsedLength)) != -1) {
                if (buffer.length - (bufferUsedLength += bytesRead) >= 1024) continue;
                byte[] newBuffer = new byte[buffer.length * 2];
                System.arraycopy(buffer, 0, newBuffer, 0, bufferUsedLength);
                buffer = newBuffer;
            }
            this.contents = new byte[bufferUsedLength];
            System.arraycopy(buffer, 0, this.contents, 0, bufferUsedLength);
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }
}

