/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.architecture.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.samples.architecture.ArchitectureSketch;
import org.eclipse.sapphire.samples.architecture.Component;
import org.eclipse.sapphire.samples.architecture.ComponentDependency;
import org.eclipse.sapphire.samples.architecture.ConnectionBendpoint;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.ConnectionAddEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionBendpointsEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeAddEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeDeleteEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeMoveEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.layout.ConnectionHashKey;
import org.eclipse.sapphire.ui.diagram.layout.DiagramLayoutPersistenceService;

public class ArchitectureDiagramLayoutPersistenceService
extends DiagramLayoutPersistenceService {
    private ArchitectureSketch architecture;
    private Listener diagramPartListener;
    private Listener connectionPartListener;
    private Listener componentListener;
    private Listener componentDependencyListener;
    private Map<String, DiagramNodeBounds> nodeBounds;
    private Map<ConnectionHashKey, List<Point>> connectionBendPoints;
    private boolean dirty;
    private boolean autoLayout = false;

    protected void init() {
        super.init();
        this.architecture = (ArchitectureSketch)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getLocalModelElement();
        this.nodeBounds = new HashMap<String, DiagramNodeBounds>();
        this.connectionBendPoints = new HashMap<ConnectionHashKey, List<Point>>();
        this.dirty = false;
        this.connectionPartListener = new FilteredListener<ConnectionBendpointsEvent>(){

            protected void handleTypedEvent(ConnectionBendpointsEvent event) {
                if (event.reset()) {
                    if (ArchitectureDiagramLayoutPersistenceService.this.autoLayout) {
                        ArchitectureDiagramLayoutPersistenceService.this.addConnectionToPersistenceCache(event.part());
                        ArchitectureDiagramLayoutPersistenceService.this.refreshDirtyState();
                    } else {
                        ArchitectureDiagramLayoutPersistenceService.this.write(event.part());
                    }
                } else {
                    ArchitectureDiagramLayoutPersistenceService.this.write(event.part());
                }
            }
        };
        this.load();
        this.refreshPersistedPartsCache();
        this.addDiagramPartListener();
        this.addModelListeners();
    }

    private void setGridVisible(boolean visible) {
        this.architecture.setShowGrid(visible);
    }

    private void setGuidesVisible(boolean visible) {
        this.architecture.setShowGuides(visible);
    }

    private void read(DiagramNodePart nodePart) {
        String nodeId;
        Component component = (Component)nodePart.getLocalModelElement();
        if (!component.disposed() && this.nodeBounds.containsKey(nodeId = nodePart.getId()) && this.nodeBounds.get(nodeId) != null) {
            nodePart.setNodeBounds(this.nodeBounds.get(nodeId));
        }
    }

    private void write(DiagramNodePart nodePart) {
        Component component = (Component)nodePart.getLocalModelElement();
        if (!component.disposed()) {
            if (this.isNodeLayoutChanged(nodePart)) {
                this.architecture.detach(this.componentListener, "/Components/Position/*");
                this.writeComponentBounds(component, nodePart);
                this.architecture.attach(this.componentListener, "/Components/Position/*");
            }
            this.refreshDirtyState();
        }
    }

    public DiagramLayoutPersistenceService.DiagramConnectionInfo read(DiagramConnectionPart connPart) {
        ConnectionHashKey key = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        if (this.connectionBendPoints.containsKey(key)) {
            DiagramLayoutPersistenceService.DiagramConnectionInfo connectionInfo = new DiagramLayoutPersistenceService.DiagramConnectionInfo(this.connectionBendPoints.get(key));
            return connectionInfo;
        }
        return null;
    }

    private void write(DiagramConnectionPart connPart) {
        ComponentDependency dependency = (ComponentDependency)connPart.getLocalModelElement();
        if (!dependency.disposed()) {
            if (this.isConnectionLayoutChanged(connPart)) {
                this.architecture.detach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
                this.writeDependencyBendPoints(dependency, connPart);
                this.architecture.attach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
            }
            this.refreshDirtyState();
        }
    }

    public void dispose() {
        if (this.diagramPartListener != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).detach(this.diagramPartListener);
        }
        if (this.componentListener != null) {
            this.architecture.detach(this.componentListener, "/Components/Position/*");
        }
        if (this.componentDependencyListener != null) {
            this.architecture.detach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
        }
    }

    private void load() {
        ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).setGridVisible(((Boolean)this.architecture.isShowGrid().content()).booleanValue());
        ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).setShowGuides(((Boolean)this.architecture.isShowGuides().content()).booleanValue());
        ElementList<Component> components = this.architecture.getComponents();
        ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        for (Component component : components) {
            DiagramNodePart nodePart = ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getDiagramNodePart((Element)component);
            if (nodePart == null) continue;
            DiagramNodeBounds bounds = null;
            bounds = new DiagramNodeBounds(((Integer)component.getPosition().getX().content()).intValue(), ((Integer)component.getPosition().getY().content()).intValue(), -1, -1, false, false);
            nodePart.setNodeBounds(bounds);
            ElementList<ComponentDependency> dependencies = component.getDependencies();
            for (ComponentDependency dependency : dependencies) {
                ElementList<ConnectionBendpoint> bendpoints;
                DiagramConnectionPart connPart = this.getConnectionPart(connService, dependency);
                if (connPart == null || (bendpoints = dependency.getConnectionBendpoints()).size() <= 0) continue;
                int index = 0;
                for (ConnectionBendpoint bendpoint : bendpoints) {
                    connPart.addBendpoint(index++, ((Integer)bendpoint.getX().content()).intValue(), ((Integer)bendpoint.getY().content()).intValue());
                }
            }
        }
        for (DiagramConnectionPart connPart : connService.list()) {
            connPart.attach(this.connectionPartListener);
        }
    }

    private void handleNodeLayoutChange(Component component) {
        DiagramNodePart nodePart = ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getDiagramNodePart((Element)component);
        DiagramNodeBounds nodeBounds = new DiagramNodeBounds(((Integer)component.getPosition().getX().content()).intValue(), ((Integer)component.getPosition().getY().content()).intValue());
        nodePart.setNodeBounds(nodeBounds);
    }

    private void handleConnectionBendpointChange(ComponentDependency componentDependency) {
        ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        DiagramConnectionPart connPart = this.getConnectionPart(connService, componentDependency);
        if (connPart != null) {
            ArrayList<Point> bendpoints = new ArrayList<Point>();
            for (ConnectionBendpoint bendpoint : componentDependency.getConnectionBendpoints()) {
                bendpoints.add(new Point(((Integer)bendpoint.getX().content()).intValue(), ((Integer)bendpoint.getY().content()).intValue()));
            }
            connPart.resetBendpoints(bendpoints);
        }
    }

    private void addNodeToPersistenceCache(DiagramNodePart nodePart) {
        String nodeId = nodePart.getId();
        this.nodeBounds.put(nodeId, nodePart.getNodeBounds());
    }

    private void addConnectionToPersistenceCache(DiagramConnectionPart connPart) {
        ConnectionHashKey connKey = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        this.connectionBendPoints.put(connKey, connPart.getBendpoints());
    }

    private void addDiagramPartListener() {
        this.diagramPartListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof DiagramNodeEvent) {
                    ArchitectureDiagramLayoutPersistenceService.this.handleDiagramNodeEvent((DiagramNodeEvent)event);
                } else if (event instanceof DiagramPageEvent) {
                    ArchitectureDiagramLayoutPersistenceService.this.handleDiagramPageEvent((DiagramPageEvent)event);
                } else if (event instanceof SapphireDiagramEditorPagePart.PreAutoLayoutEvent) {
                    ArchitectureDiagramLayoutPersistenceService.this.autoLayout = true;
                } else if (event instanceof SapphireDiagramEditorPagePart.PostAutoLayoutEvent) {
                    ArchitectureDiagramLayoutPersistenceService.this.autoLayout = false;
                } else if (event instanceof ConnectionAddEvent) {
                    ArchitectureDiagramLayoutPersistenceService.this.handleConnectionAddEvent((ConnectionAddEvent)event);
                } else if (event instanceof ConnectionDeleteEvent) {
                    ArchitectureDiagramLayoutPersistenceService.this.handleConnectionDeleteEvent((ConnectionDeleteEvent)event);
                }
            }
        };
        ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).attach(this.diagramPartListener);
    }

    private void handleDiagramNodeEvent(DiagramNodeEvent event) {
        DiagramNodePart nodePart = event.part();
        if (event instanceof DiagramNodeAddEvent) {
            this.read(nodePart);
        } else if (event instanceof DiagramNodeDeleteEvent) {
            this.refreshDirtyState();
        } else if (event instanceof DiagramNodeMoveEvent) {
            DiagramNodeBounds nodeBounds = nodePart.getNodeBounds();
            if (nodeBounds.isAutoLayout()) {
                this.addNodeToPersistenceCache(nodePart);
                this.refreshDirtyState();
            } else if (!nodeBounds.isDefaultPosition()) {
                this.write(event.part());
            }
        }
    }

    protected void handleConnectionAddEvent(ConnectionAddEvent event) {
        DiagramConnectionPart connPart = event.part();
        connPart.attach(this.connectionPartListener);
        DiagramLayoutPersistenceService.DiagramConnectionInfo connectionInfo = this.read(connPart);
        if (connectionInfo != null) {
            connPart.resetBendpoints(connectionInfo.getBendPoints());
        }
    }

    protected void handleConnectionDeleteEvent(ConnectionDeleteEvent event) {
        this.refreshDirtyState();
    }

    private void handleDiagramPageEvent(DiagramPageEvent event) {
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)event.part();
        switch (event.getDiagramPageEventType()) {
            case GridStateChange: {
                this.setGridVisible(diagramPart.isGridVisible());
                break;
            }
            case GuideStateChange: {
                this.setGuidesVisible(diagramPart.isShowGuides());
                break;
            }
            case DiagramSave: {
                this.doSave();
                break;
            }
        }
    }

    private void addModelListeners() {
        this.componentListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                Component component = (Component)event.property().element().nearest(Component.class);
                if (component != null) {
                    ArchitectureDiagramLayoutPersistenceService.this.handleNodeLayoutChange(component);
                }
            }
        };
        this.componentDependencyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                ComponentDependency componentDependency = (ComponentDependency)event.property().element().nearest(ComponentDependency.class);
                if (componentDependency != null) {
                    ArchitectureDiagramLayoutPersistenceService.this.handleConnectionBendpointChange(componentDependency);
                }
            }
        };
        this.architecture.attach(this.componentListener, "/Components/Position/*");
        this.architecture.attach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
    }

    private void writeComponentBounds(Component component, DiagramNodePart node) {
        DiagramNodeBounds bounds = node.getNodeBounds();
        if (bounds.getX() != ((Integer)component.getPosition().getX().content()).intValue()) {
            component.getPosition().setX(bounds.getX());
        }
        if (bounds.getY() != ((Integer)component.getPosition().getY().content()).intValue()) {
            component.getPosition().setY(bounds.getY());
        }
    }

    private void writeDependencyBendPoints(ComponentDependency dependency, DiagramConnectionPart connPart) {
        block6: {
            int i;
            int bpInPartSize;
            int bpInModelSize;
            ElementList<ConnectionBendpoint> bpInModelList;
            block5: {
                bpInModelList = dependency.getConnectionBendpoints();
                bpInModelSize = bpInModelList.size();
                List bpInPartList = connPart.getBendpoints();
                bpInPartSize = bpInPartList.size();
                i = 0;
                int n = Math.min(bpInModelSize, bpInPartSize);
                while (i < n) {
                    ConnectionBendpoint bpInModel = (ConnectionBendpoint)bpInModelList.get(i);
                    Point bpInPart = (Point)bpInPartList.get(i);
                    if (((Integer)bpInModel.getX().content()).intValue() != bpInPart.getX()) {
                        bpInModel.setX(bpInPart.getX());
                    }
                    if (((Integer)bpInModel.getY().content()).intValue() != bpInPart.getY()) {
                        bpInModel.setY(bpInPart.getY());
                    }
                    ++i;
                }
                if (bpInModelSize >= bpInPartSize) break block5;
                i = bpInModelSize;
                while (i < bpInPartSize) {
                    ConnectionBendpoint bpInModel = (ConnectionBendpoint)bpInModelList.insert();
                    Point bpInPart = (Point)bpInPartList.get(i);
                    bpInModel.setX(bpInPart.getX());
                    bpInModel.setY(bpInPart.getY());
                    ++i;
                }
                break block6;
            }
            if (bpInModelSize <= bpInPartSize) break block6;
            i = bpInModelSize - 1;
            while (i >= bpInPartSize) {
                bpInModelList.remove(i);
                --i;
            }
        }
    }

    private void doSave() {
        this.refreshPersistedPartsCache();
        this.architecture.detach(this.componentListener, "/Components/Position/*");
        this.architecture.detach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
        for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
            Component component = (Component)nodePart.getLocalModelElement();
            if (component.disposed()) continue;
            this.writeComponentBounds(component, nodePart);
        }
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class);
        ConnectionService connService = (ConnectionService)diagramPart.service(ConnectionService.class);
        for (DiagramConnectionPart connPart : connService.list()) {
            ComponentDependency dependency = (ComponentDependency)connPart.getLocalModelElement();
            if (dependency.disposed()) continue;
            this.writeDependencyBendPoints(dependency, connPart);
        }
        this.architecture.attach(this.componentListener, "/Components/Position/*");
        this.architecture.attach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
    }

    private boolean isNodeLayoutChanged(DiagramNodePart nodePart) {
        DiagramNodeBounds newBounds = nodePart.getNodeBounds();
        boolean changed = false;
        String nodeId = nodePart.getId();
        if (this.nodeBounds.containsKey(nodeId)) {
            DiagramNodeBounds oldBounds = this.nodeBounds.get(nodeId);
            if (!newBounds.equals((Object)oldBounds)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isConnectionLayoutChanged(DiagramConnectionPart connPart) {
        List bendpoints = connPart.getBendpoints();
        ConnectionHashKey key = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        boolean changed = false;
        if (this.connectionBendPoints.containsKey(key)) {
            List<Point> oldBendpoints = this.connectionBendPoints.get(key);
            if (bendpoints.size() != oldBendpoints.size()) {
                changed = true;
            } else {
                int i = 0;
                while (i < bendpoints.size()) {
                    Point newPt = (Point)bendpoints.get(i);
                    Point oldPt = oldBendpoints.get(i);
                    if (newPt.getX() != oldPt.getX() || newPt.getY() != oldPt.getY()) {
                        changed = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!bendpoints.equals(oldBendpoints)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isDiagramLayoutChanged() {
        boolean changed = false;
        if (!((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).disposed()) {
            ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
            for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
                if (nodePart.getLocalModelElement().disposed() || !this.isNodeLayoutChanged(nodePart)) continue;
                changed = true;
                break;
            }
            for (DiagramConnectionPart connPart : connService.list()) {
                if (connPart.getLocalModelElement().disposed() || !this.isConnectionLayoutChanged(connPart)) continue;
                changed = true;
                break;
            }
        }
        return changed;
    }

    public boolean dirty() {
        return this.dirty;
    }

    private void refreshDirtyState() {
        boolean after = this.isDiagramLayoutChanged();
        if (this.dirty != after) {
            boolean before = this.dirty;
            this.dirty = after;
            this.broadcast((Event)new DiagramLayoutPersistenceService.DirtyStateEvent((Service)this, before, after));
        }
    }

    private void refreshPersistedPartsCache() {
        this.nodeBounds.clear();
        this.connectionBendPoints.clear();
        ConnectionService connService = (ConnectionService)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).service(ConnectionService.class);
        for (DiagramConnectionPart connPart : connService.list()) {
            this.addConnectionToPersistenceCache(connPart);
        }
        for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
            this.addNodeToPersistenceCache(nodePart);
        }
    }

    private DiagramConnectionPart getConnectionPart(ConnectionService connService, Element element) {
        for (DiagramConnectionPart connPart : connService.list()) {
            if (connPart.getLocalModelElement() != element) continue;
            return connPart;
        }
        return null;
    }
}

