/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.catalog;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.StandardXmlListBindingImpl;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.samples.catalog.Catalog;
import org.eclipse.sapphire.samples.catalog.Item;
import org.eclipse.sapphire.samples.catalog.Manufacturer;
import org.eclipse.sapphire.samples.catalog.MultiVariantItem;
import org.eclipse.sapphire.samples.catalog.SingleVariantItem;
import org.eclipse.sapphire.util.IdentityHashSet;
import org.eclipse.sapphire.util.ListFactory;

public final class ManufacturersBinding
extends ListPropertyBinding {
    private List<ManufacturerResource> cache = ListFactory.empty();
    private Listener listener;

    public void init(final Property property) {
        super.init(property);
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                property.refresh();
                for (Manufacturer manufacturer : ((Catalog)property.element()).getManufacturers()) {
                    manufacturer.getItems().refresh();
                }
            }
        };
        property.element().attach(this.listener, "Items/Manufacturer");
    }

    public List<? extends Resource> read() {
        List resources;
        TreeSet<String> manufacturers = new TreeSet<String>(ManufacturerNamesComparator.INSTANCE);
        for (Item item : ((Catalog)this.property().element()).getItems()) {
            manufacturers.add(item.getManufacturer().text());
        }
        ListFactory resourcesListFactory = ListFactory.start();
        IdentityHashSet reused = new IdentityHashSet();
        for (String manufacturer : manufacturers) {
            boolean found = false;
            for (ManufacturerResource resource : this.cache) {
                if (ManufacturerNamesComparator.INSTANCE.compare(manufacturer, resource.getName()) != 0) continue;
                resourcesListFactory.add((Object)resource);
                reused.add(resource);
                found = true;
                break;
            }
            if (found) continue;
            resourcesListFactory.add((Object)new ManufacturerResource(manufacturer));
        }
        for (ManufacturerResource resource : this.cache) {
            if (reused.contains((Object)resource)) continue;
            resource.dispose();
        }
        this.cache = resources = resourcesListFactory.result();
        this.cache = resources;
        return this.cache;
    }

    public ElementType type(Resource resource) {
        return Manufacturer.TYPE;
    }

    public void dispose() {
        for (ManufacturerResource resource : this.cache) {
            resource.dispose();
        }
        this.cache = null;
        this.property().element().detach(this.listener, "Items/Manufacturer");
        this.listener = null;
    }

    private static final class ManufacturerNamesComparator
    implements Comparator<String> {
        public static ManufacturerNamesComparator INSTANCE = new ManufacturerNamesComparator();

        private ManufacturerNamesComparator() {
        }

        @Override
        public int compare(String x, String y) {
            x = x == null ? "" : x.trim();
            y = y == null ? "" : y.trim();
            int xlen = x.length();
            int ylen = y.length();
            if (xlen == 0) {
                if (ylen == 0) {
                    return 0;
                }
                return Integer.MAX_VALUE;
            }
            if (ylen == 0) {
                return -2147483647;
            }
            return x.compareToIgnoreCase(y);
        }
    }

    private final class ManufacturerResource
    extends Resource {
        private String name;

        public ManufacturerResource(String name) {
            super(ManufacturersBinding.this.property().element().resource());
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            for (Item item : ((Manufacturer)this.element()).getItems()) {
                item.setManufacturer(name);
            }
        }

        protected PropertyBinding createBinding(Property property) {
            PropertyDef pdef = property.definition();
            Object binding = null;
            if (pdef == Manufacturer.PROP_NAME) {
                binding = new ValuePropertyBinding(){

                    public String read() {
                        return ManufacturerResource.this.getName();
                    }

                    public void write(String value) {
                        ManufacturerResource.this.setName(value);
                    }
                };
            } else if (pdef == Manufacturer.PROP_ITEMS) {
                binding = new StandardXmlListBindingImpl(){

                    protected void initBindingMetadata() {
                        this.xmlElementNames = new QName[]{XmlUtil.createQualifiedName((String)"Item", null), XmlUtil.createQualifiedName((String)"MultiVariantItem", null)};
                        this.modelElementTypes = new ElementType[]{SingleVariantItem.TYPE, MultiVariantItem.TYPE};
                    }

                    protected List<?> readUnderlyingList() {
                        List all = super.readUnderlyingList();
                        ListFactory filtered = ListFactory.start();
                        for (Object obj : all) {
                            XmlElement element = (XmlElement)obj;
                            String manufacturer = element.getChildNodeText("Manufacturer");
                            if (ManufacturerNamesComparator.INSTANCE.compare(ManufacturerResource.this.name, manufacturer) != 0) continue;
                            filtered.add((Object)element);
                        }
                        return filtered.result();
                    }

                    protected Object insertUnderlyingObject(ElementType type, int position) {
                        XmlElement element = (XmlElement)super.insertUnderlyingObject(type, position);
                        element.setChildNodeText("Manufacturer", ManufacturerResource.this.name, true);
                        return element;
                    }

                    protected Resource resource(Object obj) {
                        return new ChildXmlResource((Resource)ManufacturerResource.this, (XmlElement)obj);
                    }

                    protected XmlElement getXmlElement(boolean createIfNecessary) {
                        return ((XmlResource)((Catalog)ManufacturerResource.this.element().nearest(Catalog.class)).adapt(XmlResource.class)).getXmlElement(createIfNecessary);
                    }
                };
            }
            return binding;
        }
    }
}

