/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEnablementEvent;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValuePropertyContentEvent;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.FactsAggregationService;
import org.junit.After;
import org.junit.Assert;

public abstract class SapphireTestCase
extends Assert {
    private IProject project;

    protected final IProject project() throws Exception {
        if (this.project == null) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
            if (this.project.exists()) {
                this.project.delete(true, null);
            }
            this.project.create(null);
            this.project.open(null);
        }
        return this.project;
    }

    @After
    public void deleteProject() throws Exception {
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }

    protected final InputStream loadResourceAsStream(String name) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (in == null) {
            throw new IllegalArgumentException(name);
        }
        return in;
    }

    protected final String loadResource(String name) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.loadResourceAsStream(name), StandardCharsets.UTF_8));){
            char[] chars = new char[1024];
            StringBuilder buf = new StringBuilder();
            int i = r.read(chars);
            while (i != -1) {
                buf.append(chars, 0, i);
                i = r.read(chars);
            }
            return buf.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static final void assertEqualsIgnoreNewLineDiffs(String expected, String actual) {
        SapphireTestCase.assertEquals((Object)expected.trim().replace("\r", ""), (Object)actual.trim().replace("\r", ""));
    }

    protected static final void assertValidationOk(Value<?> value) {
        SapphireTestCase.assertValidationOk(value.validation());
    }

    protected static final void assertValidationOk(ElementHandle<?> handle) {
        SapphireTestCase.assertValidationOk(handle.validation());
    }

    protected static final void assertValidationOk(ElementList<?> list) {
        SapphireTestCase.assertValidationOk(list.validation());
    }

    protected static final void assertValidationOk(Element element) {
        SapphireTestCase.assertValidationOk(element.validation());
    }

    protected static final void assertValidationOk(Status status) {
        SapphireTestCase.assertEquals((Object)Status.Severity.OK, (Object)status.severity());
    }

    protected static final void assertValidationWarning(Value<?> value, String expectedMessage) {
        SapphireTestCase.assertValidationWarning(value.validation(), expectedMessage);
    }

    protected static final void assertValidationWarning(ElementHandle<?> handle, String expectedMessage) {
        SapphireTestCase.assertValidationWarning(handle.validation(), expectedMessage);
    }

    protected static final void assertValidationWarning(ElementList<?> list, String expectedMessage) {
        SapphireTestCase.assertValidationWarning(list.validation(), expectedMessage);
    }

    protected static final void assertValidationWarning(Element element, String expectedMessage) {
        SapphireTestCase.assertValidationWarning(element.validation(), expectedMessage);
    }

    protected static final void assertValidationWarning(Status status, String expectedMessage) {
        SapphireTestCase.assertEquals((Object)Status.Severity.WARNING, (Object)status.severity());
        SapphireTestCase.assertEquals((Object)expectedMessage, (Object)status.message());
    }

    protected static final void assertValidationError(Value<?> value, String expectedMessage) {
        SapphireTestCase.assertValidationError(value.validation(), expectedMessage);
    }

    protected static final void assertValidationError(ElementHandle<?> handle, String expectedMessage) {
        SapphireTestCase.assertValidationError(handle.validation(), expectedMessage);
    }

    protected static final void assertValidationError(ElementList<?> list, String expectedMessage) {
        SapphireTestCase.assertValidationError(list.validation(), expectedMessage);
    }

    protected static final void assertValidationError(Element element, String expectedMessage) {
        SapphireTestCase.assertValidationError(element.validation(), expectedMessage);
    }

    protected static final void assertValidationError(Status status, String expectedMessage) {
        SapphireTestCase.assertEquals((Object)Status.Severity.ERROR, (Object)status.severity());
        SapphireTestCase.assertEquals((Object)expectedMessage, (Object)status.message());
    }

    protected static void assertElementDisposeEvent(Event event, Element element) {
        SapphireTestCase.assertInstanceOf(event, ElementDisposeEvent.class);
        ElementDisposeEvent evt = (ElementDisposeEvent)event;
        SapphireTestCase.assertSame((Object)element, (Object)evt.element());
    }

    protected static void assertPropertyContentEvent(Event event, Property property) {
        SapphireTestCase.assertInstanceOf(event, PropertyContentEvent.class);
        PropertyContentEvent evt = (PropertyContentEvent)event;
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
    }

    protected static void assertValuePropertyContentEvent(Event event, Property property, String before, String after) {
        SapphireTestCase.assertInstanceOf(event, ValuePropertyContentEvent.class);
        ValuePropertyContentEvent evt = (ValuePropertyContentEvent)event;
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
        SapphireTestCase.assertEquals((Object)before, (Object)evt.before());
        SapphireTestCase.assertEquals((Object)after, (Object)evt.after());
    }

    protected static void assertPropertyValidationEvent(Event event, Property property, Status before, Status after) {
        SapphireTestCase.assertInstanceOf(event, PropertyValidationEvent.class);
        PropertyValidationEvent evt = (PropertyValidationEvent)event;
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
        SapphireTestCase.assertEquals((Object)before, (Object)evt.before());
        SapphireTestCase.assertEquals((Object)after, (Object)evt.after());
    }

    protected static void assertPropertyEnablementEvent(Event event, Property property, boolean before, boolean after) {
        SapphireTestCase.assertInstanceOf(event, PropertyEnablementEvent.class);
        PropertyEnablementEvent evt = (PropertyEnablementEvent)event;
        SapphireTestCase.assertSame((Object)property, (Object)evt.property());
        SapphireTestCase.assertEquals((Object)before, (Object)evt.before());
        SapphireTestCase.assertEquals((Object)after, (Object)evt.after());
    }

    protected static void assertFact(Property property, String fact) {
        SortedSet facts = ((FactsAggregationService)property.service(FactsAggregationService.class)).facts();
        SapphireTestCase.assertTrue((boolean)facts.contains(fact));
    }

    protected static void assertFact(Element element, PropertyDef property, String fact) {
        SapphireTestCase.assertFact(element.property(property), fact);
    }

    protected static void assertNoFact(Property property, String fact) {
        SortedSet facts = ((FactsAggregationService)property.service(FactsAggregationService.class)).facts();
        SapphireTestCase.assertFalse((boolean)facts.contains(fact));
    }

    protected static void assertNoFact(Element element, PropertyDef property, String fact) {
        SapphireTestCase.assertNoFact(element.property(property), fact);
    }

    protected static void assertContainsInstanceOf(Collection<?> collection, Class<?> type) {
        boolean found = false;
        for (Object obj : collection) {
            if (!type.isInstance(obj)) continue;
            found = true;
            break;
        }
        if (!found) {
            SapphireTestCase.fail((String)("Collection does not contain instance of " + type.getName() + " type."));
        }
    }

    protected static void assertInstanceOf(Object object, Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        SapphireTestCase.assertNotNull((Object)object);
        if (!type.isInstance(object)) {
            SapphireTestCase.fail((String)("Expected " + type.getSimpleName() + ". Found " + object.getClass().getSimpleName() + "."));
        }
    }

    protected static void assertSetOrder(Set<?> set, Object ... entries) {
        if (set.size() != entries.length) {
            SapphireTestCase.fail((String)"The set size does not contain the expected number of entries.");
        }
        SapphireTestCase.assertEquals(set, SapphireTestCase.set(entries));
        Iterator<?> itr = set.iterator();
        int i = 0;
        while (i < entries.length) {
            if (!MiscUtil.equal(itr.next(), (Object)entries[i])) {
                SapphireTestCase.fail((String)"The set does not have the expected order.");
            }
            ++i;
        }
    }

    @SafeVarargs
    protected static <T> List<T> list(T ... items) {
        return MiscUtil.list((Object[])items);
    }

    @SafeVarargs
    protected static <T> Set<T> set(T ... items) {
        return MiscUtil.set((Object[])items);
    }

    protected static <T> T item(Collection<T> collection, int index) {
        if (collection instanceof List) {
            return (T)((List)collection).get(index);
        }
        int size = collection.size();
        if (index >= 0 && index < size) {
            Iterator<T> itr = collection.iterator();
            T item = null;
            int i = 0;
            while (i <= index) {
                item = itr.next();
                ++i;
            }
            return item;
        }
        throw new NoSuchElementException();
    }
}

