/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.ui.util.TopologicalSorter;
import org.junit.Test;

public final class TopologicalSorterTests
extends SapphireTestCase {
    @Test
    public void test_1() {
        TopologicalSorter sorter = new TopologicalSorter();
        TopologicalSorter.Entity a = sorter.entity((Object)"A");
        TopologicalSorter.Entity b = sorter.entity((Object)"B");
        TopologicalSorter.Entity c = sorter.entity((Object)"C");
        b.before(a);
        a.after(c);
        TopologicalSorterTests.testWithCycleBreaking((TopologicalSorter<String>)sorter, TopologicalSorterTests.list(b, c, a));
    }

    @Test
    public void test_2() {
        TopologicalSorter sorter = new TopologicalSorter();
        TopologicalSorter.Entity a = sorter.entity((Object)"A");
        TopologicalSorter.Entity b = sorter.entity((Object)"B");
        TopologicalSorter.Entity c = sorter.entity((Object)"C");
        b.before(a);
        a.after(c);
        c.before(b);
        TopologicalSorterTests.testWithCycleBreaking((TopologicalSorter<String>)sorter, TopologicalSorterTests.list(c, b, a));
    }

    @Test
    public void test_3() {
        TopologicalSorter sorter = new TopologicalSorter();
        TopologicalSorter.Entity b = sorter.entity((Object)"B");
        TopologicalSorter.Entity a = sorter.entity((Object)"A");
        TopologicalSorter.Entity c = sorter.entity((Object)"C");
        b.before(a);
        a.after(c);
        c.before(b);
        TopologicalSorterTests.testWithCycleBreaking((TopologicalSorter<String>)sorter, TopologicalSorterTests.list(c, b, a));
    }

    @Test
    public void test_4() {
        TopologicalSorter sorter = new TopologicalSorter();
        TopologicalSorter.Entity a = sorter.entity((Object)"A");
        TopologicalSorter.Entity b = sorter.entity((Object)"B");
        TopologicalSorter.Entity c = sorter.entity((Object)"C");
        TopologicalSorter.Entity d = sorter.entity((Object)"D");
        a.after(b);
        b.after(c);
        c.after(d);
        d.after(b);
        TopologicalSorterTests.testWithCycleBreaking((TopologicalSorter<String>)sorter, TopologicalSorterTests.list(d, c, b, a), TopologicalSorterTests.list(TopologicalSorterTests.list(b, c, d)));
    }

    @Test
    public void test_5() {
        TopologicalSorter sorter = new TopologicalSorter();
        TopologicalSorter.Entity a = sorter.entity((Object)"A");
        TopologicalSorter.Entity b = sorter.entity((Object)"B");
        TopologicalSorter.Entity c = sorter.entity((Object)"C");
        TopologicalSorter.Entity d = sorter.entity((Object)"D");
        TopologicalSorter.Entity e = sorter.entity((Object)"E");
        TopologicalSorter.Entity f = sorter.entity((Object)"F");
        TopologicalSorter.Entity g = sorter.entity((Object)"G");
        TopologicalSorter.Entity h = sorter.entity((Object)"H");
        a.after(b);
        b.after(c);
        c.after(d);
        d.after(b);
        c.after(e);
        e.after(f);
        f.after(g);
        g.after(e);
        f.after(h);
        TopologicalSorterTests.testWithCycleBreaking((TopologicalSorter<String>)sorter, TopologicalSorterTests.list(d, g, h, f, e, c, b, a), TopologicalSorterTests.list(TopologicalSorterTests.list(b, c, d), TopologicalSorterTests.list(e, f, g)));
    }

    @Test
    public void test_6() {
        TopologicalSorter sorter = new TopologicalSorter();
        TopologicalSorter.Entity a = sorter.entity((Object)"A");
        TopologicalSorter.Entity b = sorter.entity((Object)"B");
        TopologicalSorter.Entity c = sorter.entity((Object)"C");
        a.after(b);
        b.after(c);
        c.after(a);
        TopologicalSorterTests.testWithCycleBreaking((TopologicalSorter<String>)sorter, TopologicalSorterTests.list(c, b, a), TopologicalSorterTests.list(TopologicalSorterTests.list(a, b, c)));
    }

    @Test
    public void test_7() {
        TopologicalSorter sorter = new TopologicalSorter();
        TopologicalSorter.Entity a = sorter.entity((Object)"A");
        TopologicalSorter.Entity b = sorter.entity((Object)"B");
        TopologicalSorter.Entity c = sorter.entity((Object)"C");
        TopologicalSorter.Entity d = sorter.entity((Object)"D");
        TopologicalSorter.Entity e = sorter.entity((Object)"E");
        TopologicalSorter.Entity f = sorter.entity((Object)"F");
        TopologicalSorter.Entity g = sorter.entity((Object)"G");
        TopologicalSorter.Entity h = sorter.entity((Object)"H");
        TopologicalSorter.Entity i = sorter.entity((Object)"I");
        a.after(b);
        b.after(c);
        c.after(d);
        d.after(e);
        e.after(h);
        h.after(i);
        i.after(b);
        h.after(g);
        g.after(f);
        f.after(e);
        TopologicalSorterTests.testWithCycleBreaking((TopologicalSorter<String>)sorter, TopologicalSorterTests.list(i, f, g, h, e, d, c, b, a), TopologicalSorterTests.list(TopologicalSorterTests.list(b, c, d, e, h, i), TopologicalSorterTests.list(e, h, g, f)));
    }

    @Test
    public void test_8() {
        TopologicalSorter sorter = new TopologicalSorter();
        TopologicalSorter.Entity b = sorter.entity((Object)"B");
        TopologicalSorter.Entity c = sorter.entity((Object)"C");
        TopologicalSorter.Entity d = sorter.entity((Object)"D");
        TopologicalSorter.Entity e = sorter.entity((Object)"E");
        TopologicalSorter.Entity f = sorter.entity((Object)"F");
        TopologicalSorter.Entity g = sorter.entity((Object)"G");
        TopologicalSorter.Entity h = sorter.entity((Object)"H");
        TopologicalSorter.Entity i = sorter.entity((Object)"I");
        b.after(c);
        c.after(d);
        d.after(e);
        e.after(h);
        h.after(i);
        i.after(b);
        h.after(g);
        g.after(f);
        f.after(e);
        TopologicalSorterTests.testWithCycleBreaking((TopologicalSorter<String>)sorter, TopologicalSorterTests.list(i, f, g, h, e, d, c, b), TopologicalSorterTests.list(TopologicalSorterTests.list(b, c, d, e, h, i), TopologicalSorterTests.list(e, h, g, f)));
    }

    @Test
    public void test_9() {
        TopologicalSorter sorter = new TopologicalSorter();
        TopologicalSorter.Entity a = sorter.entity((Object)"A");
        TopologicalSorter.Entity b = sorter.entity((Object)"B");
        a.after(b);
        b.after(b);
        TopologicalSorterTests.testWithCycleBreaking((TopologicalSorter<String>)sorter, TopologicalSorterTests.list(b, a), TopologicalSorterTests.list(TopologicalSorterTests.list(b)));
    }

    @Test
    public void test_10() {
        TopologicalSorter sorter = new TopologicalSorter();
        TopologicalSorter.Entity a = sorter.entity((Object)"A");
        TopologicalSorter.Entity b = sorter.entity((Object)"B");
        TopologicalSorter.Entity c = sorter.entity((Object)"C");
        TopologicalSorter.Entity d = sorter.entity((Object)"D");
        TopologicalSorter.Entity e = sorter.entity((Object)"E");
        TopologicalSorter.Entity f = sorter.entity((Object)"F");
        TopologicalSorter.Entity g = sorter.entity((Object)"G");
        TopologicalSorter.Entity h = sorter.entity((Object)"H");
        a.after(b);
        b.after(c);
        c.after(d);
        d.after(b);
        e.after(f);
        f.after(g);
        f.after(h);
        TopologicalSorterTests.testWithCycleBreaking((TopologicalSorter<String>)sorter, TopologicalSorterTests.list(d, c, b, a, g, h, f, e), TopologicalSorterTests.list(TopologicalSorterTests.list(b, c, d)));
    }

    private static void testWithCycleBreaking(TopologicalSorter<String> sorter, List<TopologicalSorter.Entity> expectedOrder) {
        TopologicalSorterTests.testWithCycleBreaking(sorter, expectedOrder, Collections.emptyList());
    }

    private static void testWithCycleBreaking(TopologicalSorter<String> sorter, List<TopologicalSorter.Entity> expectedOrder, List<List<TopologicalSorter.Entity>> expectedCycles) {
        final ArrayList actualCycles = new ArrayList();
        TopologicalSorter.CycleListener listener = new TopologicalSorter.CycleListener(){

            public void handleCycle(List<TopologicalSorter.Entity> cycle) {
                actualCycles.add(cycle);
            }
        };
        sorter.addCycleListener(listener);
        List actualOrder = sorter.sort();
        ArrayList<String> expectedOrderAsStrings = new ArrayList<String>();
        for (TopologicalSorter.Entity entity : expectedOrder) {
            expectedOrderAsStrings.add((String)entity.data());
        }
        TopologicalSorterTests.assertEquals(expectedOrderAsStrings, (Object)actualOrder);
        TopologicalSorterTests.assertEquals(expectedCycles, actualCycles);
    }
}

