/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.index;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.index.TestElement;
import org.junit.Test;

public final class IndexFunctionTests
extends TestExpr {
    @Test
    public void testIndexFunction() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            Element entry = element.getList().insert();
            ModelElementFunctionContext context = new ModelElementFunctionContext(entry);
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ This.Index }").evaluate((FunctionContext)context);){
                IndexFunctionTests.assertEquals((Object)0, (Object)fr.value());
                element.getList().insert();
                IndexFunctionTests.assertEquals((Object)0, (Object)fr.value());
                element.getList().insert(0);
                IndexFunctionTests.assertEquals((Object)1, (Object)fr.value());
                element.getList().moveDown(entry);
                IndexFunctionTests.assertEquals((Object)2, (Object)fr.value());
                element.getList().remove(0);
                IndexFunctionTests.assertEquals((Object)1, (Object)fr.value());
                element.getList().remove(0);
                IndexFunctionTests.assertEquals((Object)0, (Object)fr.value());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testIndexFunctionOnRoot() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ This.Index }").evaluate((FunctionContext)context);){
                Status st = fr.status();
                IndexFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
                IndexFunctionTests.assertEquals((Object)"Cannot determine index if parent is not a list.", (Object)st.message());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testIndexFunctionOnElementPropertyContent() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            Element child = element.getElement().content(true);
            ModelElementFunctionContext context = new ModelElementFunctionContext(child);
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ This.Index }").evaluate((FunctionContext)context);){
                Status st = fr.status();
                IndexFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
                IndexFunctionTests.assertEquals((Object)"Cannot determine index if parent is not a list.", (Object)st.message());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

