/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.severity;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.severity.TestElement;
import org.junit.Test;

public final class SeverityFunctionTests
extends TestExpr {
    @Test
    public void testSeverityFunction() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ IntegerValue.Validation.Severity }").evaluate((FunctionContext)context);){
            SeverityFunctionTests.assertEquals((Object)Status.Severity.OK, (Object)fr.value());
            element.setIntegerValue(3);
            SeverityFunctionTests.assertEquals((Object)Status.Severity.OK, (Object)fr.value());
            element.setIntegerValue("abc");
            SeverityFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)fr.value());
            element.setIntegerValue(4);
            SeverityFunctionTests.assertEquals((Object)Status.Severity.OK, (Object)fr.value());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSeverityFunctionNull() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Severity( null ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            SeverityFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            SeverityFunctionTests.assertEquals((Object)"Function Severity does not accept nulls in position 0.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSeverityFunctionWrongType() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Severity( 'abc' ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            SeverityFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            SeverityFunctionTests.assertEquals((Object)"Function Severity( java.lang.String ) is undefined.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

