/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.validation.property;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.validation.property.TestElement;
import org.junit.Test;

public final class PropertyValidationFunctionTests
extends TestExpr {
    @Test
    public void testValidationFunction() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ IntegerValue.Validation }").evaluate((FunctionContext)context);){
            PropertyValidationFunctionTests.assertValidationOk((Status)fr.value());
            element.setIntegerValue(3);
            PropertyValidationFunctionTests.assertValidationOk((Status)fr.value());
            element.setIntegerValue("abc");
            PropertyValidationFunctionTests.assertValidationError((Status)fr.value(), "\"abc\" is not a valid integer");
            element.setIntegerValue(4);
            PropertyValidationFunctionTests.assertValidationOk((Status)fr.value());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testValidationFunctionNull() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Validation( null ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            PropertyValidationFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            PropertyValidationFunctionTests.assertEquals((Object)"Function Validation does not accept nulls in position 0.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testValidationFunctionWrongType() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Validation( 'abc' ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            PropertyValidationFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            PropertyValidationFunctionTests.assertEquals((Object)"Function Validation( java.lang.String ) is undefined.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

