/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.t0018;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.t0018.TestElement;
import org.junit.Test;

public final class TestExpr0018
extends TestExpr {
    @Test
    public void testFailSafeWithBoolean() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        element.setBooleanValue("abc");
        element.setBooleanValueWithDefault("abc");
        TestExpr0018.assertEquals((Object)"abc", (Object)element.getBooleanValue().text());
        TestExpr0018.assertEquals(null, (Object)element.getBooleanValue().content());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValue }", String.class, Boolean.TRUE, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValue }", Boolean.class, Boolean.TRUE, Boolean.TRUE);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValue }", Boolean.class, null, Boolean.FALSE);
        TestExpr0018.assertEquals((Object)"abc", (Object)element.getBooleanValueWithDefault().text());
        TestExpr0018.assertEquals((Object)Boolean.TRUE, (Object)element.getBooleanValueWithDefault().content());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValueWithDefault }", String.class, Boolean.TRUE, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValueWithDefault }", Boolean.class, Boolean.TRUE, Boolean.TRUE);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ BooleanValueWithDefault }", Boolean.class, null, Boolean.TRUE);
    }

    @Test
    public void testFailSafeWithInteger() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        element.setIntegerValue("abc");
        element.setIntegerValueWithDefault("abc");
        TestExpr0018.assertEquals((Object)"abc", (Object)element.getIntegerValue().text());
        TestExpr0018.assertEquals(null, (Object)element.getIntegerValue().content());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValue }", String.class, 2, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValue }", Integer.class, 2, 2);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValue }", Integer.class, null, 0);
        TestExpr0018.assertEquals((Object)"abc", (Object)element.getIntegerValueWithDefault().text());
        TestExpr0018.assertEquals((Object)1, (Object)element.getIntegerValueWithDefault().content());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValueWithDefault }", String.class, 2, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValueWithDefault }", Integer.class, 2, 1);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ IntegerValueWithDefault }", Integer.class, null, 1);
    }

    @Test
    public void testFailSafeWithEnum() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        element.setEnumValue("abc");
        element.setEnumValueWithDefault("abc");
        TestExpr0018.assertEquals((Object)"abc", (Object)element.getEnumValue().text());
        TestExpr0018.assertEquals(null, (Object)element.getEnumValue().content());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValue }", String.class, (Object)TestElement.EnumType.B, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValue }", TestElement.EnumType.class, (Object)TestElement.EnumType.B, (Object)TestElement.EnumType.B);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValue }", TestElement.EnumType.class, null, null);
        TestExpr0018.assertEquals((Object)"abc", (Object)element.getEnumValueWithDefault().text());
        TestExpr0018.assertEquals((Object)((Object)TestElement.EnumType.A), (Object)element.getEnumValueWithDefault().content());
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValueWithDefault }", String.class, (Object)TestElement.EnumType.B, "abc");
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValueWithDefault }", TestElement.EnumType.class, (Object)TestElement.EnumType.B, (Object)TestElement.EnumType.A);
        TestExpr0018.assertFailSafeValueEquals((FunctionContext)context, "${ EnumValueWithDefault }", TestElement.EnumType.class, null, (Object)TestElement.EnumType.A);
    }

    protected static void assertFailSafeValueEquals(FunctionContext context, String expr, Class<?> type, Object def, Object expected) {
        TestExpr0018.testForExpectedValue(context, FailSafeFunction.create((Function)ExpressionLanguageParser.parse((String)expr), (Function)Literal.create(type), (Function)Literal.create((Object)def)), expected);
    }
}

