/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.xsd.all;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlAllGroup;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.xsd.all.TestElement;
import org.junit.Test;

public final class XmlSchemaAllGroupTests
extends SapphireTestCase {
    @Test
    public void testSchemaParsing() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema((String)"http://www.eclipse.org/sapphire/tests/xml/xsd/0007");
        XmlElementDefinition rootElementDef = schema.getElement("root");
        XmlAllGroup rootContentModel = (XmlAllGroup)rootElementDef.getContentModel();
        List rootNestedContent = rootContentModel.getNestedContent();
        XmlSchemaAllGroupTests.assertEquals((long)2L, (long)rootNestedContent.size());
        XmlElementDefinition aElementDef = (XmlElementDefinition)rootNestedContent.get(0);
        XmlSchemaAllGroupTests.assertEquals((Object)"a", (Object)aElementDef.getName().getLocalPart());
        XmlSequenceGroup aContentModel = (XmlSequenceGroup)aElementDef.getContentModel();
        List aNestedContent = aContentModel.getNestedContent();
        XmlSchemaAllGroupTests.assertEquals((long)4L, (long)aNestedContent.size());
        XmlSchemaAllGroupTests.assertEquals((Object)"aa", (Object)((XmlElementDefinition)aNestedContent.get(0)).getName().getLocalPart());
        XmlSchemaAllGroupTests.assertEquals((Object)"ab", (Object)((XmlElementDefinition)aNestedContent.get(1)).getName().getLocalPart());
        XmlSchemaAllGroupTests.assertEquals((Object)"ac", (Object)((XmlElementDefinition)aNestedContent.get(2)).getName().getLocalPart());
        XmlSchemaAllGroupTests.assertEquals((Object)"ad", (Object)((XmlElementDefinition)aNestedContent.get(3)).getName().getLocalPart());
        XmlElementDefinition bElementDef = (XmlElementDefinition)rootNestedContent.get(1);
        XmlSchemaAllGroupTests.assertEquals((Object)"b", (Object)bElementDef.getName().getLocalPart());
        XmlSequenceGroup bContentModel = (XmlSequenceGroup)bElementDef.getContentModel();
        List bNestedContent = bContentModel.getNestedContent();
        XmlSchemaAllGroupTests.assertEquals((long)4L, (long)bNestedContent.size());
        XmlSchemaAllGroupTests.assertEquals((Object)"ba", (Object)((XmlElementDefinition)bNestedContent.get(0)).getName().getLocalPart());
        XmlSchemaAllGroupTests.assertEquals((Object)"bb", (Object)((XmlElementDefinition)bNestedContent.get(1)).getName().getLocalPart());
        XmlSchemaAllGroupTests.assertEquals((Object)"bc", (Object)((XmlElementDefinition)bNestedContent.get(2)).getName().getLocalPart());
        XmlSchemaAllGroupTests.assertEquals((Object)"bd", (Object)((XmlElementDefinition)bNestedContent.get(3)).getName().getLocalPart());
    }

    @Test
    public void testInsertOrder() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        TestElement root = (TestElement)TestElement.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(resourceStore)));
        TestElement.B b = (TestElement.B)root.getB().content(true);
        b.setBd("1");
        b.setBb("2");
        b.setBc("3");
        b.setBa("4");
        TestElement.A a = (TestElement.A)root.getA().content(true);
        a.setAd("1");
        a.setAa("2");
        a.setAc("3");
        a.setAb("4");
        root.resource().save();
        String result = new String(resourceStore.getContents(), StandardCharsets.UTF_8);
        XmlSchemaAllGroupTests.assertEqualsIgnoreNewLineDiffs(this.loadResource("InsertOrderExpectedResult.txt"), result);
    }
}

