/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.xsd.t0005;

import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModelReference;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlGroupContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0005.TestXmlXsd0005Circle;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0005.TestXmlXsd0005Rectangle;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0005.TestXmlXsd0005Workbook;
import org.junit.Test;

public final class TestXmlXsd0005
extends SapphireTestCase {
    private static final String NAMESPACE = "http://www.eclipse.org/sapphire/tests/xml/xsd/0005/workbook";

    @Test
    public void testSchemaParsing() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema((String)NAMESPACE);
        XmlElementDefinition workbookElementDef = schema.getElement("workbook");
        XmlSequenceGroup workbookContentModel = (XmlSequenceGroup)workbookElementDef.getContentModel();
        List workbookNestedContent = workbookContentModel.getNestedContent();
        TestXmlXsd0005.assertEquals((long)1L, (long)workbookNestedContent.size());
        XmlContentModelReference shapesGroupRef = (XmlContentModelReference)workbookNestedContent.get(0);
        XmlGroupContentModel shapesGroup = (XmlGroupContentModel)shapesGroupRef.getContentModel();
        List shapesGroupNestedContent = shapesGroup.getNestedContent();
        TestXmlXsd0005.assertEquals((long)2L, (long)shapesGroupNestedContent.size());
        XmlElementDefinition circleElementDef = (XmlElementDefinition)shapesGroupNestedContent.get(0);
        XmlSequenceGroup circleContentModel = (XmlSequenceGroup)circleElementDef.getContentModel();
        List circleNestedContent = circleContentModel.getNestedContent();
        TestXmlXsd0005.assertEquals((Object)"circle", (Object)circleElementDef.getName().getLocalPart());
        TestXmlXsd0005.assertEquals((long)3L, (long)circleNestedContent.size());
        TestXmlXsd0005.assertEquals((Object)"x", (Object)((XmlElementDefinition)circleNestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0005.assertEquals((Object)"y", (Object)((XmlElementDefinition)circleNestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0005.assertEquals((Object)"radius", (Object)((XmlElementDefinition)circleNestedContent.get(2)).getName().getLocalPart());
        XmlElementDefinition rectangleElementDef = (XmlElementDefinition)shapesGroupNestedContent.get(1);
        XmlSequenceGroup rectangleContentModel = (XmlSequenceGroup)rectangleElementDef.getContentModel();
        List rectangleNestedContent = rectangleContentModel.getNestedContent();
        TestXmlXsd0005.assertEquals((Object)"rectangle", (Object)rectangleElementDef.getName().getLocalPart());
        TestXmlXsd0005.assertEquals((long)4L, (long)rectangleNestedContent.size());
        TestXmlXsd0005.assertEquals((Object)"x", (Object)((XmlElementDefinition)rectangleNestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0005.assertEquals((Object)"y", (Object)((XmlElementDefinition)rectangleNestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0005.assertEquals((Object)"width", (Object)((XmlElementDefinition)rectangleNestedContent.get(2)).getName().getLocalPart());
        TestXmlXsd0005.assertEquals((Object)"height", (Object)((XmlElementDefinition)rectangleNestedContent.get(3)).getName().getLocalPart());
        XmlContentModel foundCircleContentModel = workbookContentModel.findChildElementContentModel(new QName(NAMESPACE, "circle"));
        TestXmlXsd0005.assertNotNull((Object)foundCircleContentModel);
        XmlContentModel foundRectangleContentModel = workbookContentModel.findChildElementContentModel(new QName(NAMESPACE, "rectangle"));
        TestXmlXsd0005.assertNotNull((Object)foundRectangleContentModel);
    }

    @Test
    public void testInsertOrder() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        TestXmlXsd0005Workbook workbook = (TestXmlXsd0005Workbook)TestXmlXsd0005Workbook.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(resourceStore)));
        TestXmlXsd0005Circle circle = (TestXmlXsd0005Circle)workbook.getShapes().insert(TestXmlXsd0005Circle.class);
        circle.setRadius(3);
        circle.setY(2);
        circle.setX(1);
        TestXmlXsd0005Rectangle rectangle = (TestXmlXsd0005Rectangle)workbook.getShapes().insert(TestXmlXsd0005Rectangle.class);
        rectangle.setHeight(4);
        rectangle.setWidth(3);
        rectangle.setY(2);
        rectangle.setX(1);
        workbook.resource().save();
        String result = new String(resourceStore.getContents(), StandardCharsets.UTF_8);
        TestXmlXsd0005.assertEqualsIgnoreNewLineDiffs(this.loadResource("ExpectedInsertionOrder.txt"), result);
    }
}

