/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.observable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ObservableMap;
import org.eclipse.sapphire.tests.EventLog;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.util.MapFactory;
import org.junit.Test;

public final class ObservableMapTests
extends SapphireTestCase {
    @Test
    public void Size() throws Exception {
        HashMap<String, String> base = new HashMap<String, String>();
        ObservableMap observable = new ObservableMap(base);
        ObservableMapTests.assertEquals((long)0L, (long)observable.size());
        base.put("a", "1");
        base.put("b", "2");
        ObservableMapTests.assertEquals((long)2L, (long)observable.size());
        base.clear();
        ObservableMapTests.assertEquals((long)0L, (long)observable.size());
    }

    @Test
    public void Empty() throws Exception {
        HashMap<String, String> base = new HashMap<String, String>();
        ObservableMap observable = new ObservableMap(base);
        ObservableMapTests.assertTrue((boolean)observable.isEmpty());
        base.put("a", "1");
        ObservableMapTests.assertFalse((boolean)observable.isEmpty());
        base.clear();
        ObservableMapTests.assertTrue((boolean)observable.isEmpty());
    }

    @Test
    public void ContainsKey() throws Exception {
        HashMap<String, String> base = new HashMap<String, String>();
        ObservableMap observable = new ObservableMap(base);
        base.put("a", "1");
        ObservableMapTests.assertTrue((boolean)observable.containsKey((Object)"a"));
        ObservableMapTests.assertFalse((boolean)observable.containsKey((Object)"b"));
        ObservableMapTests.assertFalse((boolean)observable.containsKey((Object)"1"));
        ObservableMapTests.assertFalse((boolean)observable.containsKey(new Object()));
    }

    @Test
    public void ContainsValue() throws Exception {
        HashMap<String, String> base = new HashMap<String, String>();
        ObservableMap observable = new ObservableMap(base);
        base.put("a", "1");
        ObservableMapTests.assertTrue((boolean)observable.containsValue((Object)"1"));
        ObservableMapTests.assertFalse((boolean)observable.containsValue((Object)"2"));
        ObservableMapTests.assertFalse((boolean)observable.containsValue((Object)"a"));
        ObservableMapTests.assertFalse((boolean)observable.containsValue(new Object()));
    }

    @Test
    public void EntrySet() throws Exception {
        LinkedHashMap<String, String> base = new LinkedHashMap<String, String>();
        ObservableMap observable = new ObservableMap(base);
        base.put("a", "1");
        base.put("b", "2");
        base.put("c", "3");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        Iterator itr = observable.entrySet().iterator();
        ObservableMapTests.assertTrue((boolean)itr.hasNext());
        Map.Entry a = (Map.Entry)itr.next();
        ObservableMapTests.assertEquals((Object)"a", a.getKey());
        ObservableMapTests.assertEquals((Object)"1", a.getValue());
        ObservableMapTests.assertTrue((boolean)itr.hasNext());
        Map.Entry b = (Map.Entry)itr.next();
        ObservableMapTests.assertEquals((Object)"b", b.getKey());
        ObservableMapTests.assertEquals((Object)"2", b.getValue());
        itr.remove();
        ObservableMapTests.assertEquals((Object)MapFactory.start().add((Object)"a", (Object)"1").add((Object)"c", (Object)"3").result(), base);
        ObservableMapTests.assertEquals((long)1L, (long)log.size());
        ObservableMapTests.assertTrue((boolean)itr.hasNext());
        Map.Entry c = (Map.Entry)itr.next();
        ObservableMapTests.assertEquals((Object)"c", c.getKey());
        ObservableMapTests.assertEquals((Object)"3", c.getValue());
        ObservableMapTests.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void Get() throws Exception {
        HashMap<String, String> base = new HashMap<String, String>();
        ObservableMap observable = new ObservableMap(base);
        base.put("a", "1");
        base.put("b", "2");
        ObservableMapTests.assertEquals((Object)"1", (Object)observable.get((Object)"a"));
        ObservableMapTests.assertEquals((Object)"2", (Object)observable.get((Object)"b"));
        ObservableMapTests.assertNull((Object)observable.get((Object)"c"));
    }

    @Test
    public void Put() throws Exception {
        HashMap<String, String> base = new HashMap<String, String>();
        ObservableMap observable = new ObservableMap(base);
        base.put("a", "1");
        base.put("b", "2");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.put((Object)"c", (Object)"3");
        ObservableMapTests.assertEquals((Object)MapFactory.start().add((Object)"a", (Object)"1").add((Object)"b", (Object)"2").add((Object)"c", (Object)"3").result(), base);
        ObservableMapTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.put((Object)"b", (Object)"22");
        ObservableMapTests.assertEquals((Object)MapFactory.start().add((Object)"a", (Object)"1").add((Object)"b", (Object)"22").add((Object)"c", (Object)"3").result(), base);
        ObservableMapTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.put((Object)"c", (Object)"3");
        ObservableMapTests.assertEquals((Object)MapFactory.start().add((Object)"a", (Object)"1").add((Object)"b", (Object)"22").add((Object)"c", (Object)"3").result(), base);
        ObservableMapTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void PutAll() throws Exception {
        HashMap<String, String> base = new HashMap<String, String>();
        ObservableMap observable = new ObservableMap(base);
        base.put("a", "1");
        base.put("b", "2");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.putAll(MapFactory.start().add((Object)"c", (Object)"3").add((Object)"d", (Object)"4").result());
        ObservableMapTests.assertEquals((Object)MapFactory.start().add((Object)"a", (Object)"1").add((Object)"b", (Object)"2").add((Object)"c", (Object)"3").add((Object)"d", (Object)"4").result(), base);
        ObservableMapTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.putAll(MapFactory.start().add((Object)"a", (Object)"11").add((Object)"b", (Object)"22").result());
        ObservableMapTests.assertEquals((Object)MapFactory.start().add((Object)"a", (Object)"11").add((Object)"b", (Object)"22").add((Object)"c", (Object)"3").add((Object)"d", (Object)"4").result(), base);
        ObservableMapTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.putAll(MapFactory.start().add((Object)"c", (Object)"3").add((Object)"d", (Object)"4").result());
        ObservableMapTests.assertEquals((Object)MapFactory.start().add((Object)"a", (Object)"11").add((Object)"b", (Object)"22").add((Object)"c", (Object)"3").add((Object)"d", (Object)"4").result(), base);
        ObservableMapTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void Remove() throws Exception {
        HashMap<String, String> base = new HashMap<String, String>();
        ObservableMap observable = new ObservableMap(base);
        base.put("a", "1");
        base.put("b", "2");
        base.put("c", "3");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.remove((Object)"b");
        ObservableMapTests.assertEquals((Object)MapFactory.start().add((Object)"a", (Object)"1").add((Object)"c", (Object)"3").result(), base);
        ObservableMapTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.remove((Object)"d");
        ObservableMapTests.assertEquals((Object)MapFactory.start().add((Object)"a", (Object)"1").add((Object)"c", (Object)"3").result(), base);
        ObservableMapTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void Clear() throws Exception {
        HashMap<String, String> base = new HashMap<String, String>();
        ObservableMap observable = new ObservableMap(base);
        base.put("a", "1");
        base.put("b", "2");
        base.put("c", "3");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.clear();
        ObservableMapTests.assertTrue((boolean)base.isEmpty());
        ObservableMapTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.clear();
        ObservableMapTests.assertTrue((boolean)base.isEmpty());
        ObservableMapTests.assertEquals((long)0L, (long)log.size());
    }
}

