/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.workspace.t0001;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.workspace.TestWorkspace;
import org.eclipse.sapphire.tests.workspace.t0001.TestElement;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class TestWorkspace0001
extends TestWorkspace {
    private IProject a;
    private IFile aa;
    private IFolder ab;
    private IFile aba;
    private IProject b;
    private IFile baaaaa;

    @Before
    public void before() throws Exception {
        this.a = this.createProject("a");
        this.aa = this.createFile(this.a, "a.txt");
        this.ab = this.createFolder(this.a, "b");
        this.aba = this.createFile(this.a, "b/a.txt");
        this.b = this.createProject("b");
        this.baaaaa = this.createFile(this.b, "a/a/a/a.txt");
    }

    @After
    public void after() throws Exception {
        this.deleteProject("a");
        this.deleteProject("b");
    }

    @Test
    public void testWorkspaceRelativePath() throws Exception {
        ValueProperty property = TestElement.PROP_WORKSPACE_RELATIVE_PATH;
        TestElement element = (TestElement)TestElement.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(this.aa))));
        this.testValidationOk(element, property, this.a.getFullPath());
        this.testValidationOk(element, property, this.aa.getFullPath());
        this.testValidationOk(element, property, this.ab.getFullPath());
        this.testValidationOk(element, property, this.aba.getFullPath());
        this.testValidationOk(element, property, this.b.getFullPath());
        this.testValidationOk(element, property, this.baaaaa.getFullPath());
        this.testValidationErrorNotFound(element, property, this.ab.getFile("b.txt").getFullPath());
        this.testValidationErrorNotResolved(element, property, this.b.getLocation());
    }

    @Test
    public void testProjectRelativePath() throws Exception {
        ValueProperty property = TestElement.PROP_PROJECT_RELATIVE_PATH;
        TestElement element = (TestElement)TestElement.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(this.aa))));
        this.testValidationOk(element, property, this.aa.getProjectRelativePath());
        this.testValidationOk(element, property, this.ab.getProjectRelativePath());
        this.testValidationOk(element, property, this.aba.getProjectRelativePath());
        this.testValidationErrorNotFound(element, property, this.ab.getFile("b.txt").getFullPath());
        this.testValidationErrorNotFound(element, property, this.b.getLocation());
        this.testValidationErrorNotFound(element, property, this.a.getFullPath());
        this.testValidationErrorNotFound(element, property, this.aa.getFullPath());
        this.testValidationErrorNotFound(element, property, this.ab.getFullPath());
        this.testValidationErrorNotFound(element, property, this.baaaaa.getProjectRelativePath());
        element = (TestElement)TestElement.TYPE.instantiate();
        this.testValidationError(element, property, this.aa.getProjectRelativePath(), "No context project found");
    }

    private void testValidationOk(TestElement element, ValueProperty property, IPath path) {
        element.property(property).write((Object)new Path(path.toPortableString()));
        TestWorkspace0001.assertValidationOk(element.property(property));
    }

    private void testValidationError(TestElement element, ValueProperty property, IPath path, String expectedErrorMessage) {
        element.property(property).write((Object)new Path(path.toPortableString()));
        TestWorkspace0001.assertValidationError(element.property(property), expectedErrorMessage);
    }

    private void testValidationErrorNotFound(TestElement element, ValueProperty property, IPath path) {
        this.testValidationError(element, property, path, "File or folder \"" + path.toPortableString() + "\" does not exist");
    }

    private void testValidationErrorNotResolved(TestElement element, ValueProperty property, IPath path) {
        this.testValidationError(element, property, path, "Relative path \"" + path.toPortableString() + "\" could not be resolved");
    }
}

