/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.factory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.common.utilities.exception.TmLExceptionHandler;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.exception.DeviceExceptionHandler;
import org.eclipse.tml.framework.device.internal.model.MobileService;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.device.model.handler.IServiceHandler;
import org.eclipse.tml.framework.status.IStatusTransition;
import org.eclipse.tml.framework.status.MobileStatusTransition;
import org.osgi.framework.Bundle;

public class ServiceFactory {
    private static final String ELEMENT_SERVICE = "service";
    private static final String ELEMENT_STATUS = "status";
    private static final String ATR_START_ID = "startId";
    private static final String ATR_END_ID = "endId";
    private static final String ATR_HALT_ID = "haltId";
    private static final String ATR_ID = "id";
    private static final String ATR_NAME = "name";
    private static final String ATR_ICON = "icon";
    private static final String ATR_DESCRIPTION = "description";
    private static final String ATR_PROVIDER = "provider";
    private static final String ATR_COPYRIGHT = "copyright";
    private static final String ATR_VERSION = "version";
    private static final String ATR_HANDLER = "handler";
    private static final String ATR_VISIBLE = "visible";

    public static IService createService(IExtension originalPlugin, String serviceId, IServiceHandler handler) throws TmLException {
        IExtension fromPlugin = PluginUtils.getExtension((String)"org.eclipse.tml.service", (String)serviceId);
        ArrayList<IStatusTransition> statusList = new ArrayList<IStatusTransition>();
        if (fromPlugin == null) {
            throw new TmLException();
        }
        MobileService service = new MobileService(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_ID));
        service.setName(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_NAME));
        String iconName = PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_ICON);
        ImageDescriptor image = null;
        try {
            image = DevicePlugin.getPluginImage((Bundle)fromPlugin.getDeclaringPluginDescriptor().getPlugin().getBundle(), (String)iconName);
        }
        catch (Throwable throwable) {
            TmLExceptionHandler.showException((TmLException)DeviceExceptionHandler.exception(202));
        }
        service.setImage(image);
        service.setDescription(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_DESCRIPTION));
        service.setProvider(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_PROVIDER));
        service.setCopyright(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_COPYRIGHT));
        service.setVersion(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_VERSION));
        service.setVisible(new Boolean(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_VISIBLE)));
        try {
            IServiceHandler originalHandler = (IServiceHandler)PluginUtils.getExecutableAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_HANDLER);
            if (handler != null) {
                handler.setParent(originalHandler);
                service.setHandler(handler);
            } else {
                service.setHandler(originalHandler);
            }
        }
        catch (CoreException coreException) {
            TmLExceptionHandler.showException((TmLException)DeviceExceptionHandler.exception(202));
        }
        if (originalPlugin != null) {
            List statusElementList = PluginUtils.getPluginElementList((IExtension)originalPlugin, (String)ELEMENT_SERVICE, (String)ELEMENT_STATUS);
            for (IConfigurationElement statusElement : statusElementList) {
                String startId = statusElement.getAttribute(ATR_START_ID);
                String endId = statusElement.getAttribute(ATR_END_ID);
                String haltId = statusElement.getAttribute(ATR_HALT_ID);
                MobileStatusTransition transition = new MobileStatusTransition(startId, endId, haltId);
                statusList.add(transition);
            }
        }
        service.setStatusTransitions(statusList);
        return service;
    }

    public static IService createService(String serviceId) throws TmLException {
        return ServiceFactory.createService(null, serviceId, null);
    }

    public static IService createService(IExtension fromPlugin) throws TmLException {
        String id = PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_ID);
        IServiceHandler handler = null;
        try {
            handler = (IServiceHandler)PluginUtils.getExecutableAttribute((IExtension)fromPlugin, (String)ELEMENT_SERVICE, (String)ATR_HANDLER);
        }
        catch (CoreException coreException) {}
        return ServiceFactory.createService(fromPlugin, id, handler);
    }
}

