/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.factory.DeviceFactory;
import org.eclipse.tml.framework.device.factory.DeviceRegistry;
import org.eclipse.tml.framework.device.factory.ServiceFactory;
import org.eclipse.tml.framework.device.model.IDevice;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.status.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManager {
    private static DeviceManager _instance;
    private Map<String, IDevice> devices = new HashMap<String, IDevice>();
    private Map<IInstance, IDevice> devicesForInstance;
    private Map<String, List<IService>> servicesForDevice = new HashMap<String, List<IService>>();

    private DeviceManager() {
        this.devicesForInstance = new HashMap<IInstance, IDevice>();
        this.loadDevices();
    }

    public static DeviceManager getInstance() {
        if (_instance == null) {
            _instance = new DeviceManager();
        }
        return _instance;
    }

    public void loadDevices() {
        this.devices.clear();
        this.servicesForDevice.clear();
        Collection devicesIds = PluginUtils.getInstalledPlugins((String)"org.eclipse.tml.device");
        StatusManager.getInstance();
        DeviceRegistry.getInstance().clear();
        for (String deviceId : devicesIds) {
            IDevice device = DeviceFactory.createDevice(deviceId);
            device.setServices(this.loadServices(deviceId));
            DeviceRegistry.getInstance().addDevice(device);
            this.devices.put(deviceId, device);
            this.servicesForDevice.put(deviceId, device.getServices());
        }
    }

    public List<IService> loadServices(String deviceId) {
        ArrayList<IService> services = new ArrayList<IService>();
        Collection servs = PluginUtils.getInstalledExtensions((String)"org.eclipse.tml.serviceDefinition");
        for (IExtension service : servs) {
            if (!service.getUniqueIdentifier().equals(deviceId)) continue;
            try {
                services.add(ServiceFactory.createService(service));
            }
            catch (TmLException tmLException) {}
        }
        return services;
    }

    public IDevice getDevice(String deviceId) {
        return this.devices.get(deviceId);
    }

    public IDevice getDevice(IInstance instance) {
        IDevice device = this.devicesForInstance.get(instance);
        if (device == null && (device = this.devices.get(instance.getDevice())) != null) {
            device = (IDevice)device.clone();
            device.setServices(this.loadServices(instance.getDevice()));
            device.setParent(instance);
            this.devicesForInstance.put(instance, device);
        }
        return device;
    }

    public List<IService> getServices(IDevice device) {
        return this.servicesForDevice.get(device.getId());
    }

    public List<IService> getServices(String deviceId) {
        return this.servicesForDevice.get(deviceId);
    }

    public void listDevices() {
        for (IDevice device : this.devices.values()) {
            DevicePlugin.logInfo((String)device.toString());
            List<IService> services = this.servicesForDevice.get(device.getId());
            for (IService service : services) {
                DevicePlugin.logInfo((String)("-->" + service.toString()));
            }
        }
    }
}

