/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.wizard.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.tml.framework.device.manager.DeviceManager;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.model.IDevice;
import org.eclipse.tml.framework.device.model.IInstanceBuilder;
import org.eclipse.tml.framework.device.wizard.DeviceWizardPlugin;
import org.eclipse.tml.framework.device.wizard.model.DefaultInstanceBuilder;
import org.eclipse.tml.framework.device.wizard.model.DeviceWizardBean;
import org.eclipse.tml.framework.device.wizard.model.DeviceWizardExtensionManager;
import org.eclipse.tml.framework.device.wizard.model.IWizardProjectPage;
import org.eclipse.tml.framework.device.wizard.model.IWizardPropertyPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class AbstractNewEmulatorInstanceWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private DeviceWizardBean bean;
    private IDevice device;
    private String wizardId;
    private String pluginId;

    public AbstractNewEmulatorInstanceWizard(String pluginId, String deviceId, String wizardId) {
        this.wizardId = wizardId;
        this.pluginId = pluginId;
        this.device = DeviceManager.getInstance().getDevice(deviceId);
        DeviceWizardPlugin.logInfo((String)("Device for Wizard:" + this.device.getName()));
        this.initializeBean();
        this.initializeWizardSettings();
        this.initializeDialogSettings();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        DeviceWizardPlugin.logInfo((String)"New Device Instance Wizard started");
        this.workbench = workbench;
        this.selection = selection;
    }

    private void initializeWizardSettings() {
        DeviceWizardPlugin.logInfo((String)this.getExtensionId());
        if (this.bean != null) {
            this.setNeedsProgressMonitor(this.bean.needsProgressMonitor());
            this.setForcePreviousAndNextButtons(this.bean.forcePreviousAndNextButtons());
            this.setDefaultPageImageDescriptor(DeviceWizardPlugin.imageDescriptorFromPlugin((String)this.pluginId, (String)this.bean.getImage()));
            this.setWindowTitle(this.bean.getTitle());
        }
    }

    private void initializeBean() {
        this.bean = DeviceWizardExtensionManager.getInstance().getDeviceWizardBean(this.getExtensionId());
    }

    private void initializeDialogSettings() {
        String sectionName;
        IDialogSettings settings = DeviceWizardPlugin.getDefault().getDialogSettings();
        if (settings.getSection(sectionName = ((Object)((Object)this)).getClass().getName()) == null) {
            settings.addNewSection(sectionName);
        }
        this.setDialogSettings(settings.getSection(sectionName));
    }

    public void dispose() {
        this.workbench = null;
        this.selection = null;
        this.bean = null;
    }

    public void addPages() {
        this.addProjectPage();
        this.addPropertiesPage();
        this.addOtherPage();
    }

    private void addPage(WizardPage page, String title, String description) {
        page.setTitle(title);
        page.setDescription(description);
        this.addPage((IWizardPage)page);
    }

    public void addProjectPage() {
        this.addPage(this.bean.getProjectPage(), this.bean.getProjectTitle(), this.bean.getProjectDescription());
    }

    public void addPropertiesPage() {
        this.addPage(this.bean.getPropertyPage(), this.bean.getPropertyTitle(), this.bean.getPropertyDescription());
    }

    public void addOtherPage() {
        if (this.bean.hasOtherPage()) {
            this.addPage(this.bean.getOtherPage(), this.bean.getOtherTitle(), this.bean.getOtherDescription());
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = null;
        if (nextPage == null && page != null) {
            nextPage = super.getNextPage(page);
        }
        if (nextPage != null) {
            nextPage.setPreviousPage(page);
        }
        if (page.getName().equals("projectPage")) {
            nextPage = this.getPage("propertyPage");
        }
        return nextPage;
    }

    public boolean performFinish() {
        boolean ok = false;
        try {
            IInstanceBuilder projectBuilder = this.getProjectBuilder();
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    DeviceWizardPlugin.logInfo((String)("Instance creation for Wizard:" + AbstractNewEmulatorInstanceWizard.this.getExtensionId()));
                    InstanceManager.getInstance().createProject(AbstractNewEmulatorInstanceWizard.this.getDevice(), projectBuilder, monitor);
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
            ok = true;
        }
        catch (InvocationTargetException x) {
            DeviceWizardPlugin.logError((String)x.getMessage(), (Throwable)x);
        }
        catch (InterruptedException x) {
            DeviceWizardPlugin.logError((String)x.getMessage(), (Throwable)x);
        }
        return ok;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWizardProjectPage getDefaultProjectPage() {
        return (IWizardProjectPage)this.getPage("projectPage");
    }

    public IInstanceBuilder getProjectBuilder() {
        return new DefaultInstanceBuilder(this.getDefaultProjectPage(), this.getProperties());
    }

    public IDevice getDevice() {
        return this.device;
    }

    public String getExtensionId() {
        return this.wizardId;
    }

    public Properties getProperties() {
        return ((IWizardPropertyPage)this.getPage("propertyPage")).getProperties();
    }
}

