/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device;

import java.util.List;
import org.eclipse.tml.framework.device.factory.DeviceRegistry;
import org.eclipse.tml.framework.device.factory.InstanceRegistry;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.model.IDevice;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IService;

public abstract class DeviceUtils {
    public static String[] getAllDeviceNames() {
        DeviceRegistry deviceRegistry = DeviceRegistry.getInstance();
        List<IDevice> deviceList = deviceRegistry.getDevices();
        String[] deviceNames = new String[deviceList.size()];
        int i = 0;
        for (IDevice device : deviceList) {
            deviceNames[i++] = device.getName();
        }
        return deviceNames;
    }

    public static String[] getAllInstanceNames() {
        InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
        List<IInstance> instanceList = instanceRegistry.getInstances();
        String[] instanceNames = new String[instanceList.size()];
        int i = 0;
        for (IInstance instance : instanceList) {
            instanceNames[i++] = instance.getName();
        }
        return instanceNames;
    }

    public static IInstance getInstance(String instanceName) {
        IInstance deviceInstanceToReturn = null;
        List<IInstance> deviceInstances = InstanceManager.getInstance().getInstancesByname(instanceName);
        if (!deviceInstances.isEmpty()) {
            deviceInstanceToReturn = deviceInstances.get(0);
        }
        return deviceInstanceToReturn;
    }

    public static IService getServiceById(IDevice device, String serviceId) {
        IService serviceToReturn = null;
        if (device != null && serviceId != null) {
            for (IService aService : device.getServices()) {
                if (!serviceId.equals(aService.getId())) continue;
                serviceToReturn = aService;
                break;
            }
        }
        return serviceToReturn;
    }
}

