/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.model.handler;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.framework.device.events.InstanceEvent;
import org.eclipse.tml.framework.device.events.InstanceEventManager;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.device.model.handler.IServiceHandler;
import org.eclipse.tml.framework.status.IStatusTransition;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceHandler
implements IServiceHandler {
    private IServiceHandler parent;
    private IService service;

    @Override
    public IServiceHandler getParent() {
        return this.parent;
    }

    @Override
    public void run(IInstance instance) throws TmLException {
        if (!this.verifyStatus(instance)) {
            throw new TmLException();
        }
        this.createJob(instance, null);
    }

    public void run(IInstance instance, Map<Object, Object> arguments) throws TmLException {
        if (!this.verifyStatus(instance)) {
            throw new TmLException();
        }
        this.createJob(instance, arguments);
    }

    public IStatus run(IInstance instance, Map<Object, Object> arguments, IProgressMonitor monitor) throws TmLException {
        if (!this.verifyStatus(instance)) {
            throw new TmLException();
        }
        String jobName = this.service != null ? this.service.getName() : "";
        return this.doRun(instance, arguments, jobName, monitor);
    }

    private void createJob(IInstance instance, Map<Object, Object> arguments) {
        String jobName = this.service != null ? this.service.getName() : "";
        Job serviceJob = new Job(jobName){

            public IStatus run(IProgressMonitor monitor) {
                return ServiceHandler.this.doRun(instance, arguments, jobName, monitor);
            }
        };
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getProgressService().showInDialog(null, serviceJob);
            }
        });
        serviceJob.schedule();
    }

    private IStatus doRun(IInstance instance, Map<Object, Object> arguments, String jobName, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(jobName, 3);
        status = this.runService(instance, arguments, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (status.isOK()) {
            if (this.parent != null) {
                if (this.parent instanceof ServiceHandler) {
                    status = ((ServiceHandler)this.parent).updatingService(instance, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    this.parent.updatingService(instance);
                    monitor.worked(1);
                }
            } else {
                status = this.updatingService(instance, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        this.updateStatus(instance, status);
        monitor.done();
        return status;
    }

    @Override
    public void setService(IService service) {
        this.service = service;
    }

    @Override
    public IService getService() {
        return this.service;
    }

    public abstract IStatus runService(IInstance var1, Map<Object, Object> var2, IProgressMonitor var3);

    public abstract IStatus updatingService(IInstance var1, IProgressMonitor var2);

    @Override
    public abstract IServiceHandler newInstance();

    @Override
    public void updatingService(IInstance instance) {
    }

    public void updateStatus(IInstance instance, IStatus status) {
        IStatusTransition transition = this.getService().getStatusTransitions(instance.getStatus());
        if (status.isOK()) {
            instance.setStatus(transition.getEndId());
        } else {
            instance.setStatus(transition.getHaltId());
        }
        InstanceEventManager.getInstance().fireInstanceUpdated(new InstanceEvent(instance));
    }

    public boolean verifyStatus(IInstance instance) {
        IStatusTransition transition = this.getService().getStatusTransitions(instance.getStatus());
        return transition != null;
    }

    @Override
    public void setParent(IServiceHandler handler) {
        this.parent = handler;
    }

    @Override
    public Object clone() {
        IServiceHandler newHandler = this.newInstance();
        newHandler.setParent(this.parent);
        newHandler.setService(this.service);
        return newHandler;
    }
}

