/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.internal.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tml.protocol.exceptions.MalformedProtocolExtensionException;
import org.eclipse.tml.protocol.internal.model.ProtocolBean;
import org.eclipse.tml.protocol.internal.reader.ProtocolExtensionsReader;
import org.eclipse.tml.protocol.lib.IProtocolInit;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginProtocolModel {
    private static PluginProtocolModel instance;
    private Map<String, ProtocolBean> protocolDataMap = new HashMap<String, ProtocolBean>();
    private Map<String, Map<Long, ProtocolMsgDefinition>> allMessagesMap = new HashMap<String, Map<Long, ProtocolMsgDefinition>>();
    private Map<String, Collection<String>> serverMessagesMap = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> clientMessagesMap = new HashMap<String, Collection<String>>();

    private PluginProtocolModel() {
    }

    public static PluginProtocolModel getInstance() {
        if (instance == null) {
            instance = new PluginProtocolModel();
        }
        return instance;
    }

    public boolean isBigEndianProtocol(String protocolId) throws MalformedProtocolExtensionException {
        ProtocolBean bean = this.protocolDataMap.get(protocolId);
        if (bean == null) {
            bean = ProtocolExtensionsReader.readProtocolImplDef(protocolId);
            this.protocolDataMap.put(protocolId, bean);
        }
        return bean.isBigEndianProtocol();
    }

    public IProtocolInit getProtocolInit(String protocolId) throws MalformedProtocolExtensionException {
        ProtocolBean bean = this.protocolDataMap.get(protocolId);
        if (bean == null) {
            bean = ProtocolExtensionsReader.readProtocolImplDef(protocolId);
            this.protocolDataMap.put(protocolId, bean);
        }
        return bean.getProtocolInit();
    }

    public Map<Long, ProtocolMsgDefinition> getAllProtocolMessages(String protocolId) throws MalformedProtocolExtensionException {
        Map<Long, ProtocolMsgDefinition> allMessages = this.allMessagesMap.get(protocolId);
        if (allMessages == null) {
            allMessages = ProtocolExtensionsReader.readMessageDefinitions(protocolId);
            this.allMessagesMap.put(protocolId, allMessages);
        }
        return allMessages;
    }

    public Collection<String> getClientMessages(String protocolId) throws MalformedProtocolExtensionException {
        Collection<String> clientMessages = this.clientMessagesMap.get(protocolId);
        if (clientMessages == null) {
            clientMessages = ProtocolExtensionsReader.readClientMessages(protocolId);
            this.clientMessagesMap.put(protocolId, clientMessages);
        }
        return clientMessages;
    }

    public Collection<String> getServerMessages(String protocolId) throws MalformedProtocolExtensionException {
        Collection<String> serverMessages = this.serverMessagesMap.get(protocolId);
        if (serverMessages == null) {
            serverMessages = ProtocolExtensionsReader.readServerMessages(protocolId);
            this.serverMessagesMap.put(protocolId, serverMessages);
        }
        return serverMessages;
    }
}

