/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib.internal.model;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolInit;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolInitException;
import org.eclipse.tml.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerProtocolEngineFactory {
    private ProtocolHandle handle;
    private IProtocolInit protocolInitializer;
    private Map<Long, ProtocolMsgDefinition> allMessages;
    private Collection<String> incomingMessages;
    private Collection<String> outgoingMessages;
    private IProtocolExceptionHandler exceptionHandler;
    private boolean isBigEndianProtocol;

    public ServerProtocolEngineFactory(ProtocolHandle handle, IProtocolInit protocolInitializer, Map<Long, ProtocolMsgDefinition> allMessages, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolExceptionHandler exceptionHandler, boolean isBigEndianProtocol) throws ProtocolInitException {
        if (protocolInitializer == null) {
            throw new ProtocolInitException("An initializer must be provided to run the server protocol");
        }
        this.handle = handle;
        this.protocolInitializer = protocolInitializer;
        this.allMessages = allMessages;
        this.incomingMessages = incomingMessages;
        this.outgoingMessages = outgoingMessages;
        this.exceptionHandler = exceptionHandler;
        this.isBigEndianProtocol = isBigEndianProtocol;
    }

    public ProtocolEngine getServerProtocolEngine() {
        ProtocolEngine eng = new ProtocolEngine(this.handle, this.protocolInitializer, this.allMessages, this.incomingMessages, this.outgoingMessages, this.exceptionHandler, this.isBigEndianProtocol, true, 0);
        return eng;
    }

    public Map<Long, ProtocolMsgDefinition> getAllMessages() {
        return this.allMessages;
    }

    public Collection<String> getIncomingMessages() {
        return this.incomingMessages;
    }

    public Collection<String> getOutgoingMessages() {
        return this.outgoingMessages;
    }

    public IProtocolExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public boolean isBigEndianProtocol() {
        return this.isBigEndianProtocol;
    }
}

