/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.ui;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.linuxtools.tools.ITool;
import org.eclipse.tml.linuxtools.ui.Messages;

public class DialogLogin
extends TitleAreaDialog {
    private final String WINDOW_TITLE = Messages.LoginDialog_Window_Title;
    private final String WINDOW_MESSAGE = Messages.LoginDialog_Window_Message;
    private final String WINDOW_MESSAGE_LOGIN_INVALID = Messages.LoginDialog_Msg_Login_Invalid;
    private final String LABEL_USER = Messages.LoginDialog_Label_User;
    private final String LABEL_PASSWORD = Messages.LoginDialog_Label_Password;
    private Text userText;
    private Text passwordText;
    private ITool tool;
    private boolean login_retry = false;

    public DialogLogin(Shell parentShell, ITool tool) {
        this(parentShell, tool, false);
    }

    public DialogLogin(Shell parentShell, ITool tool, boolean login_retry) {
        super(parentShell);
        this.login_retry = login_retry;
        this.tool = tool;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.WINDOW_TITLE);
        if (this.login_retry) {
            this.setErrorMessage(this.WINDOW_MESSAGE_LOGIN_INVALID);
        } else {
            this.setMessage(this.WINDOW_MESSAGE);
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 7;
        gridLayout.marginRight = 7;
        dialogArea.setLayout((Layout)gridLayout);
        dialogArea.setLayoutData((Object)new GridData(1808));
        dialogArea.setFont(parent.getFont());
        GridData gridData = new GridData(768);
        Label hostLabel = new Label(dialogArea, 0);
        hostLabel.setText(this.LABEL_USER);
        this.userText = new Text(dialogArea, 2048);
        this.userText.setLayoutData((Object)gridData);
        Label portLabel = new Label(dialogArea, 0);
        portLabel.setText(this.LABEL_PASSWORD);
        this.passwordText = new Text(dialogArea, 0x400800);
        this.passwordText.setLayoutData((Object)gridData);
        return dialogArea;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected void okPressed() {
        this.tool.login(this.userText.getText(), this.passwordText.getText());
        super.okPressed();
    }

    protected void cancelPressed() {
        this.tool.disconnect();
        super.cancelPressed();
    }
}

