/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.utilities;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.linuxtools.network.IConnectionProvider;
import org.eclipse.tml.linuxtools.utilities.ProtocolDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extensions {
    private static final String PROTOCOLS_EXTENSION = "org.eclipse.tml.linuxtools.base.protocols";
    private static final String CLASS = "class";
    private static final String DEFAULT_PORT = "default_port";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CAPABILITY = "capability";

    public static List<ProtocolDescriptor> findProcotols(String[] reqCapabilities) {
        Collection extensions = PluginUtils.getInstalledExtensions((String)PROTOCOLS_EXTENSION);
        LinkedList<ProtocolDescriptor> pdList = new LinkedList<ProtocolDescriptor>();
        for (IExtension extension : extensions) {
            IConfigurationElement[] protocolElements;
            IConfigurationElement[] iConfigurationElementArray = protocolElements = extension.getConfigurationElements();
            int n = protocolElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement protocolElement = iConfigurationElementArray[n2];
                IConfigurationElement[] capabilityElements = protocolElement.getChildren(CAPABILITY);
                boolean allCapabilitiesFound = true;
                String[] stringArray = reqCapabilities;
                int n3 = reqCapabilities.length;
                int n4 = 0;
                while (n4 < n3) {
                    String reqCapability = stringArray[n4];
                    boolean capabilityMissing = true;
                    IConfigurationElement[] iConfigurationElementArray2 = capabilityElements;
                    int n5 = capabilityElements.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement capabilityElement = iConfigurationElementArray2[n6];
                        String capabilityStr = capabilityElement.getAttribute(ID);
                        if (capabilityStr.equalsIgnoreCase(reqCapability)) {
                            capabilityMissing = false;
                            break;
                        }
                        ++n6;
                    }
                    if (capabilityMissing) {
                        allCapabilitiesFound = false;
                        break;
                    }
                    ++n4;
                }
                if (allCapabilitiesFound) {
                    String protDefaultPortStr = protocolElement.getAttribute(DEFAULT_PORT);
                    Integer protDefaultPort = new Integer(protDefaultPortStr);
                    String protIdStr = protocolElement.getAttribute(ID);
                    String protNameStr = protocolElement.getAttribute(NAME);
                    try {
                        IConnectionProvider protConnProv = (IConnectionProvider)protocolElement.createExecutableExtension(CLASS);
                        pdList.add(new ProtocolDescriptor(protConnProv.getClass(), protNameStr, protIdStr, protDefaultPort));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return pdList;
    }
}

