/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics.swt;

import java.io.DataInput;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.tml.vncviewer.network.IVNCPainter;
import org.eclipse.tml.vncviewer.network.PixelFormat;
import org.eclipse.tml.vncviewer.network.RectHeader;

public class VNCSWTPainter
implements IVNCPainter,
ISWTPainter {
    static final int RED_MASK = 255;
    static final int GREEN_MASK = 65280;
    static final int BLUE_MASK = 0xFF0000;
    public static final int RAW_ENCODING = 0;
    public static final int COPY_RECT_ENCODING = 1;
    public static final int RRE_ENCODING = 2;
    public static final int HEXTILE_ENCODING = 5;
    public static final int ZRLE_ENCODING = 16;
    private PixelFormat pixelFormat;
    private int fbWidth;
    private int fbHeight;
    private ImageData imgData;

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public void setSize(int width, int height) {
        this.fbWidth = width;
        this.fbHeight = height;
        this.imgData = new ImageData(width, height, this.pixelFormat.getDepth(), new PaletteData(255, 65280, 0xFF0000));
    }

    public void processRectangle(int encoding, byte[] pixelsb, int x, int y, int width, int height) {
        switch (encoding) {
            case 0: {
                this.processRaw(pixelsb, x, y, width, height);
                break;
            }
            default: {
                VNCViewerPlugin.log(VNCSWTPainter.class).error("This encoding is not supported.");
            }
        }
    }

    private void processRaw(byte[] pixelsb, int x, int y, int width, int height) {
        int pixelsNum = width * height;
        int[] pixels = new int[this.fbWidth * height];
        int padding = this.fbWidth - x - width;
        if (x + width <= this.fbWidth && y <= this.fbHeight) {
            this.imgData.getPixels(0, y, this.fbWidth * height, pixels, 0);
        }
        int j = 0;
        while (j < pixelsNum) {
            int i;
            int line = j / width;
            int bytesPerPixel = this.pixelFormat.getBitsPerPixel() / 8;
            int pos = j * bytesPerPixel;
            int pixel = 0;
            if (this.pixelFormat.getBigEndianFlag() != 0) {
                i = 0;
                while (i < bytesPerPixel) {
                    pixel = pixel << 8 | pixelsb[pos + i] & 0xFF;
                    ++i;
                }
            } else {
                i = bytesPerPixel - 1;
                while (i >= 0) {
                    pixel = pixel << 8 | pixelsb[pos + i] & 0xFF;
                    --i;
                }
            }
            int red = pixel >> this.pixelFormat.getRedShift();
            red &= this.pixelFormat.getRedMax();
            red = red * 255 / this.pixelFormat.getRedMax();
            int green = pixel >> this.pixelFormat.getGreenShift();
            green &= this.pixelFormat.getGreenMax();
            green = green * 255 / this.pixelFormat.getGreenMax();
            int blue = pixel >> this.pixelFormat.getBlueShift();
            blue &= this.pixelFormat.getBlueMax();
            blue = blue * 255 / this.pixelFormat.getBlueMax();
            pixels[line * padding + j + (line + 1) * x] = pixel = blue << 16 | green << 8 | red;
            ++j;
        }
        this.imgData.setPixels(0, y, this.fbWidth * height, pixels, 0);
    }

    public void render() {
    }

    public ImageData getImageData() {
        return this.imgData;
    }

    public int getHeight() {
        return this.fbHeight;
    }

    public int getWidth() {
        return this.fbWidth;
    }

    public int[] getSupportedEncodings() {
        return null;
    }

    public void processRectangle(RectHeader rectHeader, DataInput in) throws Exception {
    }

    public void updateRectangle(int x1, int y1, int x2, int y2) {
    }
}

