/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics.swt.img;

import java.util.Properties;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.vncviewer.config.IPropertiesFileHandler;
import org.eclipse.tml.vncviewer.graphics.IRemoteDisplay;
import org.eclipse.tml.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.tml.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.tml.vncviewer.graphics.swt.img.Painter;
import org.eclipse.tml.vncviewer.network.IVNCPainter;

public class SWTRemoteDisplayImg
extends SWTRemoteDisplay {
    public SWTRemoteDisplayImg(Composite parent, Properties configProperties, IPropertiesFileHandler propertiesFileHandler) {
        this(parent, configProperties, propertiesFileHandler, null);
    }

    public SWTRemoteDisplayImg(Composite parent, Properties configProperties, IPropertiesFileHandler propertiesFileHandler, ISWTPainter painter_) {
        super(parent, configProperties, propertiesFileHandler);
        this.painter = painter_;
        if (this.painter == null) {
            this.painter = new Painter(this);
        }
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                SWTRemoteDisplayImg.this.paintControl(e);
            }
        };
    }

    public synchronized void start(ProtocolHandle handle) throws Exception {
        super.start(handle);
        this.canvas.getDisplay().asyncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplayImg.this.canvas.addPaintListener(SWTRemoteDisplayImg.this.paintListener);
            }
        });
        ((Painter)this.painter).addSWTRemoteDisplayImg(this);
    }

    public synchronized void stop() {
        super.stop();
        ((Painter)this.painter).removeSWTRemoteDisplayImg(this);
    }

    public IVNCPainter getPainter() {
        return (Painter)this.painter;
    }

    protected void redrawScreen() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Canvas c = SWTRemoteDisplayImg.this.getCanvas();
                if (c != null && !c.isDisposed()) {
                    c.redraw();
                }
            }
        });
    }

    protected void redrawScreen(final int x, final int y, final int width, final int height) {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Canvas c = SWTRemoteDisplayImg.this.getCanvas();
                if (c != null && !c.isDisposed()) {
                    switch (SWTRemoteDisplayImg.this.getRotation()) {
                        case ROTATION_0DEG: {
                            c.redraw(x, y, width, height, false);
                            break;
                        }
                        default: {
                            c.redraw();
                        }
                    }
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.painter != null) {
            ((Painter)this.painter).dispose();
        }
    }

    protected void paintControl(PaintEvent event) {
        ImageData id = this.painter != null ? ((Painter)this.painter).getImageData() : null;
        Image image = null;
        if (id != null) {
            id = id.scaledTo((int)((double)id.width * this.getZoomFactor()), (int)((double)id.height * this.getZoomFactor()));
            image = new Image(event.gc.getDevice(), id);
        }
        event.gc.setBackground(this.canvas.getBackground());
        event.gc.setForeground(this.canvas.getForeground());
        if (image == null) {
            event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        } else {
            Rectangle r = image.getBounds();
            int w = Math.min(event.width, r.width);
            int h = Math.min(event.height, r.height);
            int drawH = 0;
            int drawW = 0;
            int drawY = 0;
            int drawX = 0;
            Transform rotation = new Transform(event.gc.getDevice());
            switch (this.getRotation()) {
                case ROTATION_0DEG: {
                    drawX = event.x;
                    drawY = event.y;
                    drawW = w;
                    drawH = h;
                    break;
                }
                case ROTATION_180DEG: {
                    drawX = 0;
                    drawY = 0;
                    drawW = id.width;
                    drawH = id.height;
                    rotation.translate((float)id.width, (float)id.height);
                    rotation.rotate((float)IRemoteDisplay.Rotation.ROTATION_180DEG.value());
                    event.gc.setTransform(rotation);
                    break;
                }
                case ROTATION_90DEG_CLOCKWISE: {
                    drawX = 0;
                    drawY = 0;
                    drawW = id.width;
                    drawH = id.height;
                    rotation.translate((float)id.height, 0.0f);
                    rotation.rotate((float)IRemoteDisplay.Rotation.ROTATION_90DEG_CLOCKWISE.value());
                    event.gc.setTransform(rotation);
                    break;
                }
                case ROTATION_90DEG_COUNTERCLOCKWISE: {
                    drawX = 0;
                    drawY = 0;
                    drawW = id.width;
                    drawH = id.height;
                    rotation.translate(0.0f, (float)id.width);
                    rotation.rotate((float)IRemoteDisplay.Rotation.ROTATION_90DEG_COUNTERCLOCKWISE.value());
                    event.gc.setTransform(rotation);
                }
            }
            event.gc.drawImage(image, drawX, drawY, drawW, drawH, drawX, drawY, drawW, drawH);
            image.dispose();
        }
    }
}

