/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network;

import java.io.DataInput;
import java.io.IOException;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.exceptions.ProtoClientException;
import org.eclipse.tml.vncviewer.graphics.HexTilePaintStrategy;
import org.eclipse.tml.vncviewer.graphics.IPaintStrategy;
import org.eclipse.tml.vncviewer.graphics.IPainterContext;
import org.eclipse.tml.vncviewer.graphics.RREPaintStrategy;
import org.eclipse.tml.vncviewer.graphics.RawPaintStrategy;
import org.eclipse.tml.vncviewer.graphics.ZRLEPaintStrategy;
import org.eclipse.tml.vncviewer.graphics.ZlibPaintStrategy;
import org.eclipse.tml.vncviewer.network.IVNCPainter;
import org.eclipse.tml.vncviewer.network.PixelFormat;
import org.eclipse.tml.vncviewer.network.RectHeader;
import org.eclipse.tml.vncviewer.network.VNCProtocol;

public abstract class AbstractVNCPainter
implements IVNCPainter {
    protected PixelFormat pixelFormat;
    protected int bytesPerPixel;
    private int width;
    private int height;
    private IPaintStrategy rawPaintStrategy;
    private IPaintStrategy rrePaintStrategy;
    private IPaintStrategy hexTilePaintStrategy;
    private IPaintStrategy zlibPaintStrategy;
    private IPaintStrategy zrlePaintStrategy;

    public AbstractVNCPainter() {
        IPainterContext pc = this.getPainterContext();
        this.rawPaintStrategy = new RawPaintStrategy(pc);
        this.rrePaintStrategy = new RREPaintStrategy(pc);
        this.hexTilePaintStrategy = new HexTilePaintStrategy(pc);
        this.zlibPaintStrategy = new ZlibPaintStrategy(pc);
        this.zrlePaintStrategy = new ZRLEPaintStrategy(pc);
    }

    public int[] getSupportedEncodings() {
        int[] nArray = new int[5];
        nArray[0] = 5;
        nArray[1] = 16;
        nArray[2] = 6;
        nArray[3] = 2;
        return nArray;
    }

    public static int[] getSupportedEncodingsStatic() {
        int[] nArray = new int[5];
        nArray[0] = 5;
        nArray[1] = 16;
        nArray[2] = 6;
        nArray[3] = 2;
        return nArray;
    }

    public void processRectangle(RectHeader rectHeader, DataInput in) throws Exception {
        IPaintStrategy ps = this.getPaintStrategy(rectHeader.getEncoding());
        if (ps != null) {
            ps.processRectangle(rectHeader, in);
        } else {
            VNCViewerPlugin.log(AbstractVNCPainter.class).error("This encoding is not supported.");
        }
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        this.pixelFormat = pixelFormat;
        this.bytesPerPixel = pixelFormat.getBitsPerPixel() / 8;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    private byte[] readpixelsbytes(DataInput in, int bytesNum) throws ProtoClientException {
        byte[] pixelsb = new byte[bytesNum];
        try {
            in.readFully(pixelsb, 0, bytesNum);
        }
        catch (IOException ioe) {
            VNCViewerPlugin.log(VNCProtocol.class).error("Rectangle message error: " + ioe.getMessage());
            throw new ProtoClientException("Rectangle message error.");
        }
        return pixelsb;
    }

    public int[] readPixels(DataInput is, int w, int h) throws Exception {
        byte[] pixelsBucket = new byte[1];
        int[] result = new int[w * h];
        int pixelsNum = w * h;
        int bytesToRead = pixelsNum * (this.pixelFormat.getBitsPerPixel() / 8);
        pixelsBucket = this.readpixelsbytes(is, bytesToRead);
        int j = 0;
        while (j < pixelsNum) {
            boolean bigEndian;
            int pos = j * this.bytesPerPixel;
            int pixel = 0;
            boolean bl = bigEndian = this.pixelFormat.getBigEndianFlag() != 0;
            if (bigEndian) {
                int k = 0;
                while (k < this.bytesPerPixel) {
                    pixel = pixel << 8 | pixelsBucket[pos + k] & 0xFF;
                    ++k;
                }
            } else {
                int i = this.bytesPerPixel - 1;
                while (i >= 0) {
                    pixel = pixel << 8 | pixelsBucket[pos + i] & 0xFF;
                    --i;
                }
            }
            result[j] = pixel;
            ++j;
        }
        return result;
    }

    protected int readPixel(DataInput is, int bytesPerPixel) throws Exception {
        int result = 0;
        if (bytesPerPixel == 1) {
            result = is.readByte() & 0xFF;
        } else {
            boolean bigEndian;
            boolean bl = bigEndian = this.pixelFormat.getBigEndianFlag() != 0;
            if (bigEndian) {
                int jj = 0;
                while (jj < bytesPerPixel) {
                    int b = is.readUnsignedByte();
                    result = result << 8 | b & 0xFF;
                    ++jj;
                }
            } else {
                int jj = 0;
                while (jj < bytesPerPixel) {
                    int b = is.readUnsignedByte();
                    result |= (b & 0xFF) << jj * 8;
                    ++jj;
                }
            }
        }
        return result;
    }

    protected int readPixel(DataInput is) throws Exception {
        return this.readPixel(is, this.bytesPerPixel);
    }

    protected abstract IPainterContext getPainterContext();

    protected IPaintStrategy getPaintStrategy(int encoding) {
        switch (encoding) {
            case 0: {
                return this.rawPaintStrategy;
            }
            case 2: {
                return this.rrePaintStrategy;
            }
            case 5: {
                return this.hexTilePaintStrategy;
            }
            case 6: {
                return this.zlibPaintStrategy;
            }
            case 16: {
                return this.zrlePaintStrategy;
            }
        }
        return null;
    }
}

