/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network.handlers;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tml.protocol.lib.IMessageFieldsStore;
import org.eclipse.tml.protocol.lib.IRawDataHandler;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.tml.vncviewer.network.IVNCPainter;
import org.eclipse.tml.vncviewer.network.RectHeader;
import org.eclipse.tml.vncviewer.network.VNCProtocolData;
import org.eclipse.tml.vncviewer.registry.VNCProtocolRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FramebufferRectanglesHandler
implements IRawDataHandler {
    public Map<String, Object> readRawDataFromStream(ProtocolHandle handle, DataInput dataStream, IMessageFieldsStore currentlyReadFields, boolean isBigEndian) throws IOException, ProtocolRawHandlingException {
        HashMap<String, Object> fieldsMap = new HashMap<String, Object>();
        VNCProtocolData protocolData = VNCProtocolRegistry.getInstance().get(handle);
        if (protocolData != null) {
            IVNCPainter painter = protocolData.getVncPainter();
            int x = (Integer)currentlyReadFields.getFieldValue("x-position");
            int y = (Integer)currentlyReadFields.getFieldValue("y-position");
            int width = (Integer)currentlyReadFields.getFieldValue("width");
            int height = (Integer)currentlyReadFields.getFieldValue("height");
            int encoding = (Integer)currentlyReadFields.getFieldValue("encodingType");
            try {
                painter.processRectangle(new RectHeader(x, y, width, height, encoding), dataStream);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProtocolRawHandlingException((Throwable)e);
            }
        }
        return fieldsMap;
    }

    public void writeRawDataToStream(ProtocolHandle handle, ByteArrayOutputStream dataStream, ProtocolMessage messageToGetInformationFrom, boolean isBigEndian) throws ProtocolRawHandlingException {
    }
}

