/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.manager.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.factory.DeviceTypeRegistry;
import org.eclipse.tml.framework.device.factory.InstanceRegistry;
import org.eclipse.tml.framework.device.manager.persistence.IDeviceXmlTags;
import org.eclipse.tml.framework.device.manager.persistence.TmLDevice;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IInstance;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceXmlWriter
implements IDeviceXmlTags {
    public static void saveInstances(Map<String, TmLDevice> devices) {
        IPath stateLocationPath = DevicePlugin.getDefault().getStateLocation();
        File path = stateLocationPath.toFile();
        File file = new File(path, "tml_devices.xml");
        Document document = DeviceXmlWriter.createDocument(file);
        if (document != null) {
            try {
                Element root = document.getDocumentElement();
                Element instancesRoot = DeviceXmlWriter.createInstancesElement(document);
                root.appendChild(instancesRoot);
                Element devicesRoot = DeviceXmlWriter.createDevicesElement(document, devices);
                root.appendChild(devicesRoot);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                FileOutputStream outputStream = new FileOutputStream(file.getAbsoluteFile());
                StreamResult result = new StreamResult(outputStream);
                DOMSource source = new DOMSource(document);
                transformer.transform(source, result);
                outputStream.close();
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerFactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }

    private static Document createDocument(File file) {
        Document document = null;
        if (file != null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                DOMImplementation impl = builder.getDOMImplementation();
                document = impl.createDocument(null, "tml", null);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        return document;
    }

    private static Element createDevicesElement(Document document, Map<String, TmLDevice> devices) {
        Element devicesElement = document.createElement("devices");
        Element root = document.getDocumentElement();
        root.appendChild(devicesElement);
        DeviceXmlWriter.updateDevicesFromInstances(devices);
        for (TmLDevice device : devices.values()) {
            Element deviceElement = document.createElement("deviceType");
            deviceElement.setAttribute("id", device.getId());
            devicesElement.appendChild(deviceElement);
            Element devicePluginElement = document.createElement("plugin");
            Text pluginNode = document.createTextNode(device.getPlugin());
            devicePluginElement.appendChild(pluginNode);
            devicesElement.appendChild(devicePluginElement);
        }
        return devicesElement;
    }

    private static Element createInstancesElement(Document document) {
        Element instancesRoot = document.createElement("instances");
        InstanceRegistry registry = InstanceRegistry.getInstance();
        for (IInstance iIInst : registry.getInstances()) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById(iIInst.getDeviceTypeId());
            if (!device.isPersistent()) continue;
            Element element = document.createElement("instance");
            element.setAttribute("name", iIInst.getName());
            String xml_device_id = iIInst.getDeviceTypeId();
            element.setAttribute("deviceType_id", xml_device_id);
            if (element != null) {
                instancesRoot.appendChild(element);
            }
            Properties propProp = iIInst.getProperties();
            Enumeration<Object> e = propProp.keys();
            while (e.hasMoreElements()) {
                String propStr = (String)e.nextElement();
                String propValStr = propProp.getProperty(propStr);
                Element propElement = document.createElement(propStr);
                Text propNode = document.createTextNode(propValStr);
                propElement.appendChild(propNode);
                element.appendChild(propElement);
            }
        }
        return instancesRoot;
    }

    private static void updateDevicesFromInstances(Map<String, TmLDevice> devices) {
        InstanceRegistry registry = InstanceRegistry.getInstance();
        for (IInstance iIInst : registry.getInstances()) {
            String deviceId = iIInst.getDeviceTypeId();
            if (devices.containsKey(deviceId)) continue;
            TmLDevice device = new TmLDevice(deviceId, deviceId);
            devices.put(deviceId, device);
        }
    }
}

