/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.android;

import java.awt.Dimension;
import java.util.HashMap;
import org.eclipse.tml.localization.android.i18n.Messages;
import org.eclipse.tml.localization.tools.datamodel.LocaleAttribute;

public class AndroidLocaleAttribute
extends LocaleAttribute {
    public static final int INDEX_COUNTRY_CODE = 0;
    public static final int INDEX_NETWORK_CODE = 1;
    public static final int INDEX_LANGUAGE = 2;
    public static final int INDEX_REGION = 3;
    public static final int INDEX_SCREEN_ORIENTATION = 4;
    public static final int INDEX_PIXEL_DENSITY = 5;
    public static final int INDEX_TOUCH_TYPE = 6;
    public static final int INDEX_KEYBOARD_STATE = 7;
    public static final int INDEX_TEXT_INPUT_METHOD = 8;
    public static final int INDEX_NAVIGATION_METHOD = 9;
    public static final int INDEX_SCREEN_DIMENSION = 10;
    public static final int INDEX_COUNT = 11;
    private int androidType;
    private String stringValue = "";
    protected boolean isSet = false;

    public AndroidLocaleAttribute(Object value, int androidType) {
        super("", LocaleAttribute.STRING_TYPE, 0, 0, null, "", "");
        this.androidType = androidType;
        this.setAndroidValue(value);
        this.isSet = false;
    }

    public AndroidLocaleAttribute(String qualifier, int type) {
        super("", LocaleAttribute.STRING_TYPE, 0, 0, null, "", "");
        this.androidType = type;
        Object value = this.getValueAndTypeFromQualifier(qualifier);
        this.setAndroidValue(value);
    }

    public int getAndroidType() {
        return this.androidType;
    }

    private String getCountryCodeFolder(String value) {
        return "mcc" + value;
    }

    private String getLanguageFolder(String value) {
        return value.toLowerCase();
    }

    private String getNetworkCodeFolder(String value) {
        return "mnc" + value;
    }

    private String getPixelFolder(String value) {
        return String.valueOf(value) + "dpi";
    }

    private String getRegionCodeFolder(String value) {
        return "r" + value.toUpperCase();
    }

    public String getStringValue() {
        return this.stringValue;
    }

    private Object getValueAndTypeFromQualifier(String strValue) {
        Object result = null;
        switch (this.androidType) {
            case 0: {
                result = strValue.substring(3);
                break;
            }
            case 1: {
                result = strValue.substring(3);
                break;
            }
            case 2: {
                result = strValue;
                break;
            }
            case 3: {
                result = strValue.substring(1);
                break;
            }
            case 4: {
                result = strValue;
                break;
            }
            case 5: {
                int index = strValue.indexOf("dpi");
                result = strValue.substring(0, index);
                break;
            }
            case 6: {
                result = strValue;
                break;
            }
            case 7: {
                result = strValue;
                break;
            }
            default: {
                break;
            }
            case 8: {
                result = strValue;
                break;
            }
            case 9: {
                result = strValue;
                break;
            }
            case 10: {
                String[] numbers = strValue.split("x");
                int x = Integer.parseInt(numbers[0]);
                int y = Integer.parseInt(numbers[1]);
                result = new Dimension(x, y);
            }
        }
        return result;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void setAndroidValue(Object value) {
        switch (this.androidType) {
            case 0: {
                this.setCountryCodeNode(value);
                break;
            }
            case 1: {
                this.setNetworkCodeNode(value);
                break;
            }
            case 2: {
                this.setLanguageNode(value);
                break;
            }
            case 3: {
                this.setRegionNode(value);
                break;
            }
            case 4: {
                this.setOrientationNode(value);
                break;
            }
            case 5: {
                this.setPixelNode(value);
                break;
            }
            case 6: {
                this.setTouchNode(value);
                break;
            }
            case 7: {
                this.setKeyboardNode(value);
                break;
            }
            case 8: {
                this.setTextInputNode(value);
                break;
            }
            case 9: {
                this.setNavigationNode(value);
                break;
            }
            case 10: {
                this.setDimensionNode(value);
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.Unknown_Andr_Type);
            }
        }
        this.isSet = true;
    }

    public void setAttribute() {
        this.isSet = true;
    }

    private void setCountryCodeNode(Object value) {
        this.displayName = "Country Code";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 3;
        this.maximumSize = 3;
        this.allowedValues = null;
        this.setIntValue(value);
        this.folderValue = this.getCountryCodeFolder(this.displayValue);
    }

    private void setDimensionNode(Object value) {
        if (!(value instanceof Dimension)) {
            throw new IllegalArgumentException(Messages.Invalid_Andr_Value);
        }
        this.displayName = "Screen Dimension";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = null;
        double y = ((Dimension)value).getWidth();
        double x = ((Dimension)value).getHeight();
        this.folderValue = this.displayValue = String.valueOf((int)x) + "x" + (int)y;
    }

    public void setIntValue(Object value) {
        Integer intValue = -1;
        if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if (value instanceof String) {
            intValue = Integer.parseInt((String)value);
        } else {
            throw new IllegalArgumentException(Messages.Invalid_Andr_Value);
        }
        if (this.fixedSize > 0 && intValue.toString().length() != this.fixedSize) {
            throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.fixedSize);
        }
        if (this.maximumSize > 0 && intValue.toString().length() > this.maximumSize) {
            throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.maximumSize);
        }
        this.displayValue = intValue.toString();
    }

    private void setKeyboardNode(Object value) {
        this.displayName = "Keyboard State";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)value);
    }

    private void setLanguageNode(Object value) {
        this.displayName = "Language";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 2;
        this.maximumSize = 2;
        this.allowedValues = null;
        this.setStringValue(value);
        this.folderValue = this.getLanguageFolder(this.displayValue);
    }

    private void setNavigationNode(Object value) {
        this.displayName = "Navigation Method";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)value);
    }

    private void setNetworkCodeNode(Object value) {
        this.displayName = "Network Code";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 3;
        this.allowedValues = null;
        this.setIntValue(value);
        this.folderValue = this.getNetworkCodeFolder(this.displayValue);
    }

    private void setOrientationNode(Object value) {
        this.displayName = "Screen Orientation";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)value);
    }

    private void setPixelNode(Object value) {
        this.displayName = "Pixel Density";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = null;
        this.setIntValue(value);
        this.folderValue = this.getPixelFolder(this.displayValue);
    }

    private void setRegionNode(Object value) {
        this.displayName = "Region";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 2;
        this.maximumSize = 2;
        this.allowedValues = null;
        this.setStringValue(value);
        this.folderValue = this.getRegionCodeFolder(this.displayValue);
    }

    private void setStringValue(Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(Messages.Invalid_Andr_Value);
        }
        if (this.type == FIXED_TEXT_TYPE) {
            this.setValuesBasedOnDisplayValue((String)value);
        } else {
            if (this.fixedSize > 0 && ((String)value).length() != this.fixedSize) {
                throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.fixedSize);
            }
            if (this.maximumSize > 0 && ((String)value).length() > this.maximumSize) {
                throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.maximumSize);
            }
            this.displayValue = (String)value;
        }
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    private void setTextInputNode(Object value) {
        this.displayName = "Text Input Method";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.setValuesBasedOnDisplayValue((String)value);
    }

    private void setTouchNode(Object value) {
        this.displayName = "Touch Screen Type";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.setValuesBasedOnDisplayValue((String)value);
    }

    public void unsetAttribute() {
        this.isSet = false;
    }
}

