/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.tools.datamodel;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tml.localization.tools.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleAttribute {
    public static int STRING_TYPE = 0;
    public static int FIXED_TEXT_TYPE = 1;
    protected String displayName = "";
    protected int type = STRING_TYPE;
    protected int fixedSize = 0;
    protected int maximumSize = 0;
    protected Map<String, String> allowedValues = null;
    protected String displayValue = null;
    protected String folderValue = null;

    public LocaleAttribute(String displayName, int type, int size, int maxSize, Map<String, String> allowedValues, String displayValue, String folderValue) {
        if (displayName == null) {
            throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_NameCannotBeNull);
        }
        if (type == FIXED_TEXT_TYPE) {
            if (allowedValues == null) {
                throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_AllowedTypesNeeded);
            }
            if (!allowedValues.containsKey(displayValue)) {
                throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_ValueNotAllowed);
            }
        }
        this.displayName = displayName;
        this.setAllowedValues(allowedValues);
        this.type = type;
        this.displayValue = displayValue;
        this.folderValue = folderValue;
        this.fixedSize = size;
        this.maximumSize = maxSize;
    }

    public boolean isValueAllowed(String value) {
        boolean result = false;
        if (this.type != FIXED_TEXT_TYPE) {
            result = true;
        }
        if (this.allowedValues != null) {
            result = this.allowedValues.containsKey(value);
        }
        return result;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type < STRING_TYPE || type > FIXED_TEXT_TYPE) {
            throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_TypeDontExist);
        }
        this.type = type;
    }

    public void setMaxSize(int size) {
        this.maximumSize = size;
    }

    public int getMaxSize() {
        return this.maximumSize;
    }

    public void setSize(int size) {
        this.fixedSize = size;
    }

    public int getSize() {
        return this.fixedSize;
    }

    public void setAllowedValues(Map<String, String> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public Collection<String> getAllowedValues() {
        if (this.allowedValues == null) {
            return null;
        }
        return this.allowedValues.keySet();
    }

    public void setValues(String displayValue, String folderValue) {
        if (displayValue == null || folderValue == null) {
            throw new IllegalAccessError(Messages.LocaleAttribute_Exception_ValueNotNull);
        }
        if (this.type == FIXED_TEXT_TYPE && !this.allowedValues.containsKey(displayValue)) {
            throw new IllegalAccessError(Messages.LocaleAttribute_Exception_ValueNotAllowed2);
        }
        this.displayValue = displayValue;
        this.folderValue = folderValue;
    }

    public void setValuesBasedOnDisplayValue(String displayValue) {
        if (displayValue == null) {
            throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_ValueNotNull2);
        }
        if (this.type != FIXED_TEXT_TYPE) {
            throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_NotAllowedMethod);
        }
        if (this.allowedValues != null) {
            this.allowedValues.containsKey(displayValue);
        }
        this.displayValue = displayValue;
        this.folderValue = displayValue;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public String getFolderValue() {
        return this.folderValue;
    }

    public boolean equals(Object arg0) {
        boolean equal = false;
        if (arg0 instanceof LocaleAttribute) {
            equal = this.displayName.equals(((LocaleAttribute)arg0).getDisplayName()) && this.folderValue.equals(((LocaleAttribute)arg0).getFolderValue());
        }
        return equal;
    }
}

