/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.tools.datamodel;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.tml.localization.tools.datamodel.LocaleInfo;
import org.eclipse.tml.localization.tools.datamodel.LocalizationFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationProject {
    private IProject project;
    private List<LocalizationFile> localizationFiles;
    private boolean dirty;
    private boolean dirtyMetaExtraData;

    public LocalizationProject(IProject project, List<LocalizationFile> files) {
        this.project = project;
        this.localizationFiles = files;
        for (LocalizationFile localizationFile : this.localizationFiles) {
            localizationFile.setLocalizationProject(this);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public List<LocalizationFile> getLocalizationFiles() {
        return this.localizationFiles;
    }

    public void setLocalizationFiles(List<LocalizationFile> localizationFiles) {
        this.localizationFiles = localizationFiles;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirtyMetaExtraData() {
        return this.dirtyMetaExtraData;
    }

    public void setDirtyMetaExtraData(boolean dirtyMetaExtraData) {
        this.dirtyMetaExtraData = dirtyMetaExtraData;
    }

    public LocalizationFile getLocalizationFile(LocaleInfo localeInfo) {
        LocalizationFile localizationFile = null;
        boolean found = false;
        Iterator<LocalizationFile> iterator = this.localizationFiles.iterator();
        while (iterator.hasNext() && !found) {
            LocalizationFile file = iterator.next();
            if (!file.getLocaleInfo().equals(localeInfo)) continue;
            localizationFile = file;
            found = true;
        }
        return localizationFile;
    }

    public LocalizationFile getLocalizationFile(IFile file) {
        LocalizationFile localizationFile = null;
        boolean found = false;
        Iterator<LocalizationFile> iterator = this.localizationFiles.iterator();
        while (iterator.hasNext() && !found) {
            LocalizationFile locFile = iterator.next();
            if (!locFile.getFile().equals((Object)file)) continue;
            localizationFile = locFile;
            found = true;
        }
        return localizationFile;
    }

    public boolean addLocalizationFile(LocalizationFile localizationFile) {
        localizationFile.setLocalizationProject(this);
        return this.localizationFiles.add(localizationFile);
    }

    public boolean removeLocalizationFile(LocalizationFile localizationFile) {
        return this.localizationFiles.remove(localizationFile);
    }
}

