/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.tools.managers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.localization.tools.datamodel.GrammarCheckerResult;
import org.eclipse.tml.localization.tools.datamodel.LocaleInfo;
import org.eclipse.tml.localization.tools.datamodel.LocalizationFile;
import org.eclipse.tml.localization.tools.datamodel.LocalizationProject;
import org.eclipse.tml.localization.tools.datamodel.StringNode;
import org.eclipse.tml.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.tml.localization.tools.managers.ProjectPreferencesManager;
import org.eclipse.tml.localization.tools.persistence.ProjectPersistenceManager;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLocalizationManager {
    private LocalizationProject localizationProject;
    private ProjectPersistenceManager projectPersistenceManager;
    private ProjectPreferencesManager projectPreferencesManager;
    private ILocalizationSchema projectLocalizationSchema;
    private IProject project;

    public ProjectLocalizationManager(IProject project, ILocalizationSchema localizationSchema) {
        this.projectPersistenceManager = new ProjectPersistenceManager(this.localizationProject);
        this.projectPreferencesManager = new ProjectPreferencesManager();
        this.projectLocalizationSchema = localizationSchema;
        try {
            ArrayList<LocalizationFile> localizationFiles = new ArrayList<LocalizationFile>();
            localizationFiles.addAll(this.projectLocalizationSchema.loadAllFiles(project).values());
            this.localizationProject = new LocalizationProject(project, localizationFiles);
            this.project = project;
            this.syncDefaultColumn();
        }
        catch (IOException e) {
            BasePlugin.logError((String)("Could not load the localization manager: " + e.getMessage()));
        }
    }

    public void reload() {
        ArrayList<LocalizationFile> localizationFiles = new ArrayList<LocalizationFile>();
        List<Object> notPersisted = new ArrayList();
        HashMap<IFile, LocalizationFile> localizationFilesMap = new HashMap<IFile, LocalizationFile>();
        notPersisted = this.getLocalizationProject().getLocalizationFiles();
        try {
            localizationFiles.addAll(this.projectLocalizationSchema.loadAllFiles(this.project).values());
            for (LocalizationFile localizationFile : localizationFiles) {
                localizationFilesMap.put(localizationFile.getFile(), localizationFile);
            }
            for (LocalizationFile localizationFile : notPersisted) {
                if (localizationFilesMap.get(localizationFile.getFile()) != null) continue;
                localizationFiles.add(localizationFile);
            }
            this.localizationProject.getLocalizationFiles().clear();
            for (LocalizationFile localizationFile : localizationFiles) {
                this.localizationProject.addLocalizationFile(localizationFile);
            }
            this.syncDefaultColumn();
        }
        catch (IOException iOException) {}
    }

    private void syncNodes(LocalizationFile destination, LocalizationFile source) {
        for (StringNode node : source.getStringNodes()) {
            destination.getStringNodeByKey(node.getKey());
        }
    }

    private void syncDefaultColumn() {
        LocalizationFile mainFile = this.localizationProject.getLocalizationFile(this.getProjectLocalizationSchema().getLocaleInfoFromID(this.getProjectLocalizationSchema().getDefaultID()));
        if (mainFile != null) {
            for (LocalizationFile locFile : this.localizationProject.getLocalizationFiles()) {
                if (locFile == mainFile) continue;
                this.syncNodes(mainFile, locFile);
            }
        }
    }

    public List<LocaleInfo> getAvailableLocales() {
        ArrayList<LocaleInfo> localeInfoList = new ArrayList<LocaleInfo>();
        List<LocalizationFile> localizationFiles = this.localizationProject.getLocalizationFiles();
        for (LocalizationFile localizationFile : localizationFiles) {
            localeInfoList.add(localizationFile.getLocaleInfo());
        }
        return localeInfoList;
    }

    public boolean createOrUpdateFile(LocaleInfo localeInfo, List<StringNode> stringNodes) {
        LocalizationFile localizationFile = new LocalizationFile(null, localeInfo, stringNodes);
        try {
            this.projectLocalizationSchema.createFile(localizationFile);
        }
        catch (TmLException tmLException) {
            BasePlugin.logInfo((String)"Error while creating file");
        }
        return true;
    }

    public boolean saveProject() {
        this.syncDefaultColumn();
        List<LocalizationFile> localizationFiles = this.localizationProject.getLocalizationFiles();
        for (LocalizationFile localizationFile : localizationFiles) {
            if (!localizationFile.isToBeDeleted()) {
                if (localizationFile.isDirty()) {
                    try {
                        this.projectLocalizationSchema.updateFile(localizationFile);
                    }
                    catch (TmLException tmLException) {
                        BasePlugin.logInfo((String)"Error while updating file");
                    }
                }
                if (!localizationFile.isDirtyMetaExtraData()) continue;
                this.projectPersistenceManager.saveData();
                continue;
            }
            try {
                File tempFile;
                localizationFile.getFile().delete(true, null);
                if (localizationFile.getFile().getLocation() == null || !(tempFile = new File(localizationFile.getFile().getLocation().removeLastSegments(1).toOSString())).exists() || !tempFile.isDirectory() || tempFile.listFiles().length != 0) continue;
                tempFile.delete();
            }
            catch (CoreException e) {
                BasePlugin.logError((String)("Could not delete file: " + e.getMessage()));
            }
        }
        ArrayList<LocalizationFile> tempLocalizationFiles = new ArrayList<LocalizationFile>(localizationFiles);
        for (LocalizationFile localizationFile : tempLocalizationFiles) {
            if (!localizationFile.isToBeDeleted()) continue;
            this.localizationProject.removeLocalizationFile(localizationFile);
        }
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ProjectLocalizationManager.this.localizationProject.getProject().refreshLocal(2, monitor);
                    }
                    catch (CoreException coreException) {}
                }
            }, null);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        this.localizationProject.setDirty(false);
        return true;
    }

    public void translateAndCreateFile(LocalizationFile localizationFile, LocaleInfo newFileLangInfo) {
    }

    public List<GrammarCheckerResult> checkGrammar(LocalizationFile localizationFile) {
        return null;
    }

    public Map<LocalizationFile, List<GrammarCheckerResult>> checkAllGrammar() {
        return null;
    }

    public LocalizationProject getLocalizationProject() {
        return this.localizationProject;
    }

    public void clearMetaData(Class _class) {
    }

    public void clearExtraInfo(Class _class) {
    }

    public void markFileForDeletion(LocalizationFile localizationFile) {
        localizationFile.setToBeDeleted(true);
    }

    public void deleteFileMetaExtraData(IFile file) {
    }

    public ILocalizationSchema getProjectLocalizationSchema() {
        return this.projectLocalizationSchema;
    }

    public ProjectPersistenceManager getProjectPersistenceManager() {
        return this.projectPersistenceManager;
    }

    public ProjectPreferencesManager getProjectPreferencesManager() {
        return this.projectPreferencesManager;
    }

    public LocaleInfo getLocaleInfoForFile(IFile file) {
        LocaleInfo localeInfo = null;
        List<LocalizationFile> localizationFiles = this.localizationProject.getLocalizationFiles();
        for (LocalizationFile localizationFile : localizationFiles) {
            if (!localizationFile.getFile().equals((Object)file)) continue;
            localeInfo = localizationFile.getLocaleInfo();
        }
        return localeInfo;
    }
}

