/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.tml.common.utilities.BasePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorSession {
    private final Map<QualifiedName, String> session;
    private final IProject project;
    private static final String PROPERTY_GROUP = "org.eclipse.tml.localization.stringeditor";

    private EditorSession(Map<QualifiedName, String> session, IProject project) {
        this.session = session;
        this.project = project;
    }

    public static EditorSession loadFromProject(IProject project) {
        EditorSession session = null;
        try {
            Map persistentProperties = project.getPersistentProperties();
            HashMap<QualifiedName, String> editorProperties = new HashMap<QualifiedName, String>();
            for (QualifiedName name : persistentProperties.keySet()) {
                if (name.getQualifier() == null || !name.getQualifier().contains(PROPERTY_GROUP)) continue;
                editorProperties.put(name, (String)persistentProperties.get(name));
            }
            session = new EditorSession(editorProperties, project);
        }
        catch (CoreException e) {
            BasePlugin.logError((String)("Error loading editor preferences from project: " + project.getName()), (Throwable)e);
        }
        return session;
    }

    public String getProperty(String namespace, PROPERTY p) {
        String qualifier = "org.eclipse.tml.localization.stringeditor." + namespace;
        QualifiedName property = new QualifiedName(qualifier, p.name());
        return this.session.get(property);
    }

    public void setProperty(String name, PROPERTY p, String value) {
        String qualifier = "org.eclipse.tml.localization.stringeditor." + name;
        QualifiedName property = new QualifiedName(qualifier, p.name());
        this.session.put(property, value);
    }

    public void save() {
        if (this.project.exists()) {
            for (QualifiedName key : this.session.keySet()) {
                try {
                    this.project.setPersistentProperty(key, this.session.get(key));
                }
                catch (CoreException e) {
                    BasePlugin.logError((String)("Error saving preferences to project: " + this.project.getName()), (Throwable)e);
                }
            }
        }
    }

    public void clean() {
        if (this.project.exists()) {
            for (QualifiedName key : this.session.keySet()) {
                try {
                    this.project.setPersistentProperty(key, null);
                }
                catch (CoreException e) {
                    BasePlugin.logError((String)("Error cleaning preferences of project: " + this.project.getName()), (Throwable)e);
                }
            }
            this.session.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PROPERTY {
        WIDTH,
        VISIBLE,
        ORDER,
        SORT_BY_COLUMN,
        HIGHLIGHT_CHANGES,
        SEARCH_TEXT,
        SHOW_COMMENTS,
        FILTER_BY_KEY;

    }
}

