/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tml.localization.stringeditor.datatype.CellInfo;
import org.eclipse.tml.localization.stringeditor.datatype.RowInfo;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.tml.localization.stringeditor.i18n.Messages;

public class StringEditorColumnLabelProvider
extends ColumnLabelProvider {
    private final String column;
    private final StringEditorPart editor;
    private final Color searchColor = new Color((Device)Display.getDefault(), 255, 200, 200);

    public StringEditorColumnLabelProvider(String column, StringEditorPart editor) {
        this.column = column;
        this.editor = editor;
    }

    public String getText(Object element) {
        if (this.column.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            return super.getText((Object)((RowInfo)element).getKey());
        }
        return super.getText((Object)((RowInfo)element).getCells().get(this.column));
    }

    public String getToolTipText(Object element) {
        CellInfo cell;
        String comment = null;
        RowInfo row = (RowInfo)element;
        if (this.column.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            if (!row.getStatus().isOK()) {
                StringBuilder builder = new StringBuilder();
                IStatus[] iStatusArray = row.getStatus().getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    builder.append(child.getMessage());
                    builder.append("\n");
                    ++n2;
                }
                comment = builder.toString();
            }
        } else if (this.editor.getShowCellComments() && (cell = row.getCells().get(this.column)) != null && cell.getValue() != null && cell.getValue().trim().length() > 0) {
            comment = cell.getComment() != null ? cell.getComment() : "";
        }
        return comment;
    }

    public Color getBackground(Object element) {
        Color c = null;
        if (this.column.equals(Messages.StringEditorPart_KeyLabel)) {
            c = Display.getDefault().getSystemColor(19);
        } else {
            CellInfo cell = ((RowInfo)element).getCells().get(this.column);
            String searchText = this.editor.getSearchText();
            if (cell != null) {
                if (searchText.length() > 0 && cell.toString().toLowerCase().contains(searchText.toLowerCase())) {
                    c = this.searchColor;
                } else if (this.editor.getHighlightChanges() && cell.isDirty()) {
                    c = Display.getDefault().getSystemColor(29);
                }
            }
        }
        return c;
    }

    public Image getImage(Object element) {
        Image statusImage = null;
        if (this.column.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            RowInfo row = (RowInfo)element;
            switch (row.getStatus().getSeverity()) {
                case 4: {
                    statusImage = this.editor.getErrorImage();
                    break;
                }
                case 2: {
                    statusImage = this.editor.getWarningImage();
                    break;
                }
                default: {
                    statusImage = this.editor.getOKImage();
                }
            }
        }
        return statusImage;
    }
}

