/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.localization.stringeditor.EditorExtensionLoader;
import org.eclipse.tml.localization.stringeditor.StringEditorPlugin;
import org.eclipse.tml.localization.stringeditor.datatype.CellInfo;
import org.eclipse.tml.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.tml.localization.stringeditor.datatype.IModelChangedListener;
import org.eclipse.tml.localization.stringeditor.datatype.RowInfo;
import org.eclipse.tml.localization.stringeditor.editor.EditorSession;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorCellHighlighter;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorColumnLabelProvider;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorColumnViewerEditorActivationListener;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorViewerContentProvider;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorViewerEditableTooltipSupport;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorViewerModel;
import org.eclipse.tml.localization.stringeditor.editor.TableComparator;
import org.eclipse.tml.localization.stringeditor.editor.input.IInputChangeListener;
import org.eclipse.tml.localization.stringeditor.editor.input.IStringEditorInput;
import org.eclipse.tml.localization.stringeditor.editor.operations.AddColumnOperation;
import org.eclipse.tml.localization.stringeditor.editor.operations.AddKeyOperation;
import org.eclipse.tml.localization.stringeditor.editor.operations.EditCellOperation;
import org.eclipse.tml.localization.stringeditor.editor.operations.EditorOperation;
import org.eclipse.tml.localization.stringeditor.editor.operations.RemoveColumnOperation;
import org.eclipse.tml.localization.stringeditor.editor.operations.RemoveKeyOperation;
import org.eclipse.tml.localization.stringeditor.editor.operations.RevertColumnToSavedStateOperation;
import org.eclipse.tml.localization.stringeditor.editor.operations.TranslateOperation;
import org.eclipse.tml.localization.stringeditor.i18n.Messages;
import org.eclipse.tml.localization.stringeditor.providers.ContentProvider;
import org.eclipse.tml.localization.stringeditor.providers.ICellValidator;
import org.eclipse.tml.localization.stringeditor.providers.IOperationProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.EditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditorPart
extends EditorPart {
    private final IUndoContext undoContext;
    private final IOperationHistory operationHistory;
    private Set<String> changedColumns = new HashSet<String>();
    private boolean needToPromptFileSystemChange = false;
    private final IInputChangeListener inputChangeListener = new IInputChangeListener(){

        public void columnChanged(String columnID) {
            StringEditorPart.this.markColumnAsChanged(columnID);
        }

        public void projectRemoved() {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    StringEditorPart.this.getEditorSite().getPage().closeEditor((IEditorPart)StringEditorPart.this, false);
                }
            });
        }
    };
    private TableViewer viewer = null;
    private static final int SIZE_HINT = 14;
    private ColumnSelectionListener listener;
    private int activeColumn;
    private ContentProvider contentProvider;
    private EditorSession session;
    private static String SORTER_PROPERTY_NAME = "sorter";
    private static String PREVIOUS_WIDTH_PROPERTY_NAME = "previous.width";
    private IProject associatedProject = null;
    private Button highlightChangesButton = null;
    private boolean highlightChanges = false;
    private Text searchText = null;
    private String searchString = "";
    private Button showCellCommentsButton = null;
    private boolean showCellComments = false;
    private Text filterByKeyText = null;
    private String filterByKeyString = "";
    private Button applyFilterButton = null;
    private Form editorComposite;
    private Image errorImage;
    private Image warningImage;
    private Image okImage;

    public StringEditorPart() {
        this.undoContext = new ObjectUndoContext((Object)this);
        this.operationHistory = OperationHistoryFactory.getOperationHistory();
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public IProject getAssociatedProject() {
        return this.associatedProject;
    }

    public IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            IFile file = ((IFileEditorInput)input).getFile();
            this.contentProvider = EditorExtensionLoader.getInstance().getContentProviderForFileInput(file);
            if (this.contentProvider == null) {
                throw new Exception("An input provider for the given file was not found: " + ((IFileEditorInput)input).getFile().getLocation().toOSString());
            }
            IStringEditorInput stringEditorInput = this.contentProvider.getEditorInput();
            IOperationProvider operationProvider = this.contentProvider.getOperationProvider();
            ICellValidator cellValidator = this.contentProvider.getValidator();
            stringEditorInput.init(file.getProject());
            operationProvider.init(file.getProject());
            cellValidator.init(file.getProject());
            this.session = EditorSession.loadFromProject(file.getProject());
            this.associatedProject = file.getProject();
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(stringEditorInput);
            this.setPartName(stringEditorInput.getTitle());
            stringEditorInput.addInputChangeListener(this.inputChangeListener);
            this.errorImage = new Image((Device)Display.getDefault(), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK").getImageData().scaledTo(16, 16));
            this.warningImage = new Image((Device)Display.getDefault(), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK").getImageData().scaledTo(16, 16));
            this.okImage = new Image((Device)Display.getDefault(), StringEditorPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tml.localization.stringeditor", (String)"icons/obj16_ok.png").getImageData());
        }
        catch (Exception e) {
            this.handleInitFailure(e, input, site);
        }
    }

    private void handleInitFailure(Exception e, IEditorInput input, IEditorSite site) {
        MessageDialog.openError((Shell)new Shell(), (String)"Error loading editor. Some available editor will be opened", (String)e.getMessage());
        IEditorDescriptor[] editors = PlatformUI.getWorkbench().getEditorRegistry().getEditors("*." + ((IFileEditorInput)input).getFile().getLocation().getFileExtension());
        if (editors.length > 0) {
            int i = 0;
            IEditorDescriptor editor = null;
            while (i < editors.length && editor == null) {
                if (!editors[i].getId().equals(site.getId())) {
                    editor = editors[i];
                }
                ++i;
            }
            if (editor != null) {
                try {
                    site.getPage().openEditor(input, editor.getId());
                }
                catch (PartInitException partInitException) {}
            }
            site.getPage().closeEditor((IEditorPart)this, false);
        }
    }

    public IProgressMonitor getProgressMonitor() {
        return this.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    private void createOptionsSection(FormToolkit toolkit, final Form parent) {
        GridData layoutData = new GridData(4, 4, true, false, 4, 1);
        GridLayout layout = new GridLayout(5, false);
        ExpandableComposite expandableComposite = toolkit.createExpandableComposite(parent.getBody(), 2);
        expandableComposite.setLayoutData((Object)layoutData);
        expandableComposite.setText(Messages.StringEditorPart_OptionsText);
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.layout(true);
            }
        });
        layoutData = new GridData(4, 4, true, false, 5, 1);
        Composite optionsComposite = toolkit.createComposite((Composite)expandableComposite);
        optionsComposite.setLayoutData((Object)layoutData);
        optionsComposite.setLayout((Layout)layout);
        expandableComposite.setClient((Control)optionsComposite);
        this.highlightChangesButton = toolkit.createButton(optionsComposite, Messages.StringEditorPart_HighlightChangesLabel, 32);
        layoutData = new GridData(4, 4, true, false, 2, 1);
        this.highlightChangesButton.setLayoutData((Object)layoutData);
        this.highlightChangesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringEditorPart.this.highlightChanges = ((Button)e.widget).getSelection();
                for (RowInfo info : StringEditorPart.this.getModel().getRows().values()) {
                    StringEditorPart.this.viewer.update((Object)info, null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label search = toolkit.createLabel(optionsComposite, String.valueOf(Messages.StringEditorPart_SearchLabel) + ": ");
        layoutData = new GridData(131072, 0x1000000, true, false, 1, 1);
        search.setLayoutData((Object)layoutData);
        this.searchText = toolkit.createText(optionsComposite, "", 2048);
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.searchText.setLayoutData((Object)layoutData);
        this.searchText.addModifyListener((ModifyListener)new SearchTextModifyListener());
        this.showCellCommentsButton = toolkit.createButton(optionsComposite, Messages.StringEditorPart_ShowCellCommentsButtonText, 32);
        layoutData = new GridData(4, 4, true, false, 2, 1);
        this.showCellCommentsButton.setLayoutData((Object)layoutData);
        this.showCellCommentsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringEditorPart.this.showCellComments = ((Button)e.widget).getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label filter = toolkit.createLabel(optionsComposite, String.valueOf(Messages.StringEditorPart_FilterByKeyLabel) + ": ");
        layoutData = new GridData(131072, 0x1000000, true, false, 1, 1);
        filter.setLayoutData((Object)layoutData);
        this.filterByKeyText = toolkit.createText(optionsComposite, "", 2048);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.filterByKeyText.setLayoutData((Object)layoutData);
        this.filterByKeyText.addModifyListener((ModifyListener)new FilterByKeyTextModifyListener());
        this.filterByKeyText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    StringEditorPart.this.getEditorViewer().refresh();
                }
            }
        });
        this.applyFilterButton = toolkit.createButton(optionsComposite, "Apply", 8);
        layoutData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.applyFilterButton.setLayoutData((Object)layoutData);
        this.applyFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringEditorPart.this.getEditorViewer().refresh();
            }
        });
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        IStringEditorInput stringEditorInput = this.getEditorInput();
        List<ColumnInfo> infos = stringEditorInput.getColumns();
        this.editorComposite = toolkit.createForm(parent);
        this.editorComposite.setText(stringEditorInput.getName() != null && stringEditorInput.getName().trim().length() > 0 ? stringEditorInput.getName() : Messages.StringEditorPart_EditorTitle);
        GridLayout layout = new GridLayout(4, false);
        layout.horizontalSpacing = 0;
        this.editorComposite.getBody().setLayout((Layout)layout);
        this.createOptionsSection(toolkit, this.editorComposite);
        Table t = toolkit.createTable(this.editorComposite.getBody(), 101122);
        this.viewer = new TableViewer(t);
        GridData layoutData = new GridData(4, 4, true, true, 4, 1);
        this.viewer.getTable().setLayoutData((Object)layoutData);
        this.listener = new ColumnSelectionListener(this.viewer);
        this.createColumn(Messages.StringEditorPart_KeyLabel, Messages.StringEditorPart_KeyTooltip, 0).getColumn().setMoveable(false);
        this.restoreSession(infos);
        TableComparator sorter = new TableComparator();
        this.viewer.setComparator((ViewerComparator)sorter);
        this.viewer.getTable().setSortDirection(1024);
        this.viewer.setContentProvider((IContentProvider)new StringEditorViewerContentProvider());
        this.viewer.setInput((Object)new StringEditorViewerModel(infos, this.getContentProvider().getValidator()));
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        StringEditorViewerEditableTooltipSupport.enableFor((ColumnViewer)this.viewer, 2, this);
        final MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StringEditorPart.this.fillContextMenu(manager);
            }
        });
        this.viewer.getControl().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                int position = ((StringEditorPart)StringEditorPart.this).viewer.getTable().toControl((int)e.x, (int)e.y).x + StringEditorPart.this.viewer.getTable().getHorizontalBar().getSelection();
                int x = 0;
                int i = 0;
                while (i < StringEditorPart.this.viewer.getTable().getColumnCount()) {
                    if (position <= (x += StringEditorPart.this.viewer.getTable().getColumn(i).getWidth())) {
                        StringEditorPart.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
                if (position >= x) {
                    StringEditorPart.this.activeColumn = 0;
                }
                StringEditorPart.this.viewer.getControl().setMenu(mgr.createContextMenu(StringEditorPart.this.viewer.getControl()));
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ((RowInfo)element).getKey().toLowerCase().contains(StringEditorPart.this.getKeyFilter().toLowerCase());
            }
        });
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                boolean activate = false;
                activate = event.stateMask == 0 ? (event.character >= ' ' && event.character <= '\u007f' ? true : (event.keyCode == 13 || event.keyCode == 127 || event.keyCode == 0x1000050 ? true : super.isEditorActivationEvent(event))) : super.isEditorActivationEvent(event);
                return activate;
            }
        };
        activationStrategy.setEnableEditorActivationWithKeyboard(true);
        StringEditorCellHighlighter highlighter = new StringEditorCellHighlighter(this.viewer);
        CellNavigationStrategy navigationStrategy = new CellNavigationStrategy();
        TableViewerFocusCellManager manager = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)highlighter, navigationStrategy);
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)manager, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)58);
        this.viewer.getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)new StringEditorColumnViewerEditorActivationListener(this.viewer));
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StringEditorPart.this.session.clean();
                StringEditorPart.this.saveSession();
                StringEditorPart.this.saveOptions();
                StringEditorPart.this.session.save();
            }
        });
        this.viewer.getTable().layout(true, true);
        this.restoreOptions();
        this.session.clean();
        this.saveOptions();
        this.saveSession();
        this.session.save();
        this.setEditorStatus(this.getEditorInput().validate());
        this.getModel().addListener(new IModelChangedListener(){

            public void modelChanged(StringEditorViewerModel model) {
                StringEditorPart.this.setEditorStatus(StringEditorPart.this.getEditorInput().validate());
            }
        });
        if (this.contentProvider.getContextHelpID() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.viewer.getTable(), this.contentProvider.getContextHelpID());
        }
    }

    private void saveSession() {
        Table t = this.viewer.getTable();
        int i = 0;
        while (i < t.getColumnCount()) {
            TableColumn c = t.getColumn(t.getColumnOrder()[i]);
            this.session.setProperty(c.getText(), EditorSession.PROPERTY.ORDER, new Integer(i).toString());
            this.session.setProperty(c.getText(), EditorSession.PROPERTY.VISIBLE, new Boolean(c.getResizable()).toString());
            this.session.setProperty(c.getText(), EditorSession.PROPERTY.WIDTH, new Integer(c.getWidth()).toString());
            ++i;
        }
        this.session.setProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.SORT_BY_COLUMN, t.getSortColumn() != null ? t.getSortColumn().getText() : null);
        this.session.setProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.ORDER, t.getSortDirection() == 128 ? new Integer(128).toString() : new Integer(1024).toString());
    }

    private void saveOptions() {
        String namespace = this.associatedProject.getName();
        this.session.setProperty(namespace, EditorSession.PROPERTY.HIGHLIGHT_CHANGES, Boolean.toString(this.highlightChanges));
        this.session.setProperty(namespace, EditorSession.PROPERTY.SEARCH_TEXT, this.searchString.length() > 0 ? this.searchString : null);
        this.session.setProperty(namespace, EditorSession.PROPERTY.SHOW_COMMENTS, Boolean.toString(this.showCellComments));
        this.session.setProperty(namespace, EditorSession.PROPERTY.FILTER_BY_KEY, this.filterByKeyString.length() > 0 ? this.filterByKeyString : null);
    }

    private void restoreOptions() {
        String namespace = this.associatedProject.getName();
        String search = this.session.getProperty(namespace, EditorSession.PROPERTY.SEARCH_TEXT);
        String highlight = this.session.getProperty(namespace, EditorSession.PROPERTY.HIGHLIGHT_CHANGES);
        String showComments = this.session.getProperty(namespace, EditorSession.PROPERTY.SHOW_COMMENTS);
        String filterByKey = this.session.getProperty(namespace, EditorSession.PROPERTY.FILTER_BY_KEY);
        if (search != null) {
            this.searchText.setText(search);
            this.searchString = this.searchText.getText();
        }
        if (highlight != null) {
            this.highlightChangesButton.setSelection(new Boolean(highlight).booleanValue());
            this.highlightChanges = this.highlightChangesButton.getSelection();
        }
        if (showComments != null) {
            this.showCellCommentsButton.setSelection(new Boolean(showComments).booleanValue());
            this.showCellComments = this.showCellCommentsButton.getSelection();
        }
        if (filterByKey != null) {
            this.filterByKeyText.setText(filterByKey);
            this.filterByKeyString = this.filterByKeyText.getText();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void restoreSession(List<ColumnInfo> infos) {
        void var5_8;
        ArrayList<Object> reordered = new ArrayList<Object>(infos.size());
        HashMap<Integer, ColumnInfo> orderMap = new HashMap<Integer, ColumnInfo>();
        ArrayList<ColumnInfo> out = new ArrayList<ColumnInfo>();
        for (ColumnInfo columnInfo : infos) {
            String order = this.session.getProperty(columnInfo.getId(), EditorSession.PROPERTY.ORDER);
            if (order != null) {
                orderMap.put(Integer.parseInt(order), columnInfo);
                continue;
            }
            out.add(columnInfo);
        }
        boolean bl = true;
        while (var5_8 < infos.size() + 1) {
            ColumnInfo info = (ColumnInfo)orderMap.get((int)var5_8);
            if (info != null) {
                reordered.add(info);
            } else if (out.size() > 0) {
                reordered.add((ColumnInfo)out.remove(0));
            }
            ++var5_8;
        }
        for (ColumnInfo columnInfo : reordered) {
            String width = this.session.getProperty(columnInfo.getId(), EditorSession.PROPERTY.WIDTH);
            String visible = this.session.getProperty(columnInfo.getId(), EditorSession.PROPERTY.VISIBLE);
            TableViewerColumn column = this.createColumn(columnInfo.getId(), columnInfo.getTooltip(), -1);
            if (width != null) {
                column.getColumn().setWidth(Integer.parseInt(width));
            }
            if (visible == null) continue;
            column.getColumn().setResizable(Boolean.parseBoolean(visible));
        }
        String string = this.session.getProperty(Messages.StringEditorPart_KeyLabel, EditorSession.PROPERTY.WIDTH);
        String visible = this.session.getProperty(Messages.StringEditorPart_KeyLabel, EditorSession.PROPERTY.VISIBLE);
        if (string != null) {
            this.viewer.getTable().getColumn(0).setWidth(Integer.parseInt(string));
        }
        if (visible != null) {
            this.viewer.getTable().getColumn(0).setResizable(Boolean.parseBoolean(visible));
        }
        String sortBy = this.session.getProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.SORT_BY_COLUMN);
        String sortDirection = this.session.getProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.ORDER);
        if (sortBy != null && sortBy.length() > 0) {
            TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                if (c.getText().equals(sortBy)) {
                    this.viewer.getTable().setSortColumn(c);
                }
                ++n2;
            }
        } else {
            this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(0));
        }
        if (sortDirection != null) {
            try {
                int direction = Integer.parseInt(sortDirection);
                this.viewer.getTable().setSortDirection(direction);
            }
            catch (NumberFormatException numberFormatException) {
                this.viewer.getTable().setSortDirection(1024);
            }
        }
        this.viewer.refresh();
        this.saveSession();
    }

    private TableViewerColumn createColumn(String id, String tooltip, int index) {
        TableViewerColumn column = null;
        column = new TableViewerColumn(this.viewer, 0, index);
        column.setLabelProvider((CellLabelProvider)new StringEditorColumnLabelProvider(id, this));
        column.setEditingSupport((EditingSupport)new CellEditingSupport(this.viewer, id));
        column.getColumn().setText(id);
        column.getColumn().setToolTipText(tooltip);
        column.getColumn().setWidth(14 * (column.getColumn().getText().length() + 1));
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        column.getColumn().addSelectionListener((SelectionListener)this.listener);
        return column;
    }

    private void hideColumn(TableColumn c) {
        c.setResizable(false);
        c.setData(PREVIOUS_WIDTH_PROPERTY_NAME, (Object)new Integer(c.getWidth()).toString());
        c.setWidth(0);
    }

    private void showColumn(TableColumn c) {
        c.setResizable(true);
        int preferedSize = -1;
        try {
            preferedSize = Integer.parseInt((String)c.getData(PREVIOUS_WIDTH_PROPERTY_NAME));
        }
        catch (NumberFormatException numberFormatException) {}
        c.setWidth(preferedSize > 0 ? preferedSize : 0);
        if (preferedSize == -1) {
            c.pack();
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        this.addColumnsVisibilityActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add(this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId()));
        manager.add(this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.REDO.getId()));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new AddKeyAction());
        manager.add((IAction)new RemoveKeyAction());
        manager.add((IAction)new AddColumnAction());
        manager.add((IAction)new RemoveColumnAction());
        manager.add((IAction)new RevertToSavedAction());
        manager.add((IAction)new TranslateColumnAction());
    }

    private void addColumnsVisibilityActions(IMenuManager manager) {
        MenuManager showColumnsMenu = new MenuManager(Messages.StringEditorPart_ShowColumnsSubmenuLabel);
        TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (!column.getText().equals(Messages.StringEditorPart_KeyLabel)) {
                showColumnsMenu.add((IAction)new HideShowColumnAction(column.getText(), 2, column));
            }
            ++n2;
        }
        showColumnsMenu.add((IContributionItem)new Separator());
        showColumnsMenu.add((IAction)new HideShowAllColumnsAction(Messages.StringEditorPart_ShowAllColumnsActionName, 1, this.viewer.getTable(), true));
        showColumnsMenu.add((IAction)new HideShowAllColumnsAction(Messages.StringEditorPart_HideAllColumnsActionName, 1, this.viewer.getTable(), false));
        manager.add((IContributionItem)showColumnsMenu);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.promptUpdateConflicts()) {
            this.getEditorInput().save();
            List<RowInfo> changed = this.getModel().save();
            this.updateViewer(changed);
            this.fireDirtyPropertyChanged();
            this.setEditorStatus(this.getEditorInput().validate());
        }
    }

    public void updateViewer(List<RowInfo> rows) {
        if (rows != null) {
            for (RowInfo changedRow : rows) {
                this.viewer.update((Object)changedRow, null);
            }
        } else {
            for (RowInfo changedRow : this.getModel().getRows().values()) {
                this.viewer.update((Object)changedRow, null);
            }
        }
    }

    public boolean isDirty() {
        return this.getEditorInput().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public TableViewer getEditorViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)new UndoActionHandler((IWorkbenchPartSite)this.getEditorSite(), this.getUndoContext()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)new RedoActionHandler((IWorkbenchPartSite)this.getEditorSite(), this.getUndoContext()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.SAVE.getId(), (IAction)ActionFactory.SAVE.create(this.getEditorSite().getWorkbenchWindow()));
        this.viewer.getTable().setFocus();
        this.promptFileSystemChanges();
    }

    public void markColumnAsChanged(String columnID) {
        this.changedColumns.add(columnID);
        this.needToPromptFileSystemChange = true;
    }

    public boolean unmarkColumnAsChanged(String columnID) {
        return this.changedColumns.remove(columnID);
    }

    private void clearColumnsMarkedAsChanged() {
        this.changedColumns.clear();
    }

    private void promptFileSystemChanges() {
        if (this.changedColumns.size() > 0 && this.needToPromptFileSystemChange) {
            String columnNames = this.getChangedColumnNamesString();
            boolean replace = MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)Messages.StringEditorPart_FileChangedTitle, (String)NLS.bind((String)Messages.StringEditorPart_FileChangedDescription, (Object)columnNames));
            this.needToPromptFileSystemChange = false;
            if (replace) {
                HashSet<String> revertColumnNames = new HashSet<String>(this.changedColumns);
                for (String columnName : revertColumnNames) {
                    RevertColumnToSavedStateOperation operation = new RevertColumnToSavedStateOperation(Messages.StringEditorPart_RevertColumnActionOperationName, this, this.getModel().getColumn(columnName));
                    this.executeOperation(operation);
                }
            }
        }
    }

    private boolean promptUpdateConflicts() {
        boolean result = true;
        if (this.changedColumns.size() > 0) {
            String columnNames = this.getChangedColumnNamesString();
            boolean overwrite = MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)Messages.StringEditorPart_UpdateConflictTitle, (String)NLS.bind((String)Messages.StringEditorPart_UpdateConflictDescription, (Object)columnNames));
            if (!overwrite) {
                result = false;
            } else {
                this.clearColumnsMarkedAsChanged();
            }
        }
        return result;
    }

    private String getChangedColumnNamesString() {
        String result = "\n";
        int i = 1;
        for (String columnName : this.changedColumns) {
            result = String.valueOf(result) + i++ + ") " + columnName + "\n";
        }
        return result;
    }

    public ContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public TableColumn addColumn(ColumnInfo info, int index) {
        TableViewerColumn tableViewerColumn = this.createColumn(info.getId(), info.getTooltip(), index);
        this.getEditorInput().addColumn(info.getId());
        this.getModel().addColumn(info);
        for (String cellKey : info.getCells().keySet()) {
            try {
                CellInfo cell = info.getCells().get(cellKey);
                if (cell.getValue() == null) continue;
                this.getEditorInput().setValue(info.getId(), cellKey, cell.getValue());
            }
            catch (TmLException e) {
                BasePlugin.logError((String)("Error adding column: " + info.getId()), (Throwable)e);
            }
        }
        this.getEditorViewer().refresh();
        this.fireDirtyPropertyChanged();
        return tableViewerColumn.getColumn();
    }

    public IStringEditorInput getEditorInput() {
        return (IStringEditorInput)super.getEditorInput();
    }

    public void removeColumn(String columnID) {
        this.getEditorInput().removeColumn(columnID);
        this.getModel().removeColumn(columnID);
        TableColumn[] tableColumnArray = this.getEditorViewer().getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (column.getText().equals(columnID)) {
                column.dispose();
            }
            ++n2;
        }
        this.fireDirtyPropertyChanged();
        this.getEditorViewer().refresh();
    }

    public void addRow(RowInfo info) {
        this.getEditorInput().addRow(info);
        this.getModel().addRow(info);
        this.fireDirtyPropertyChanged();
    }

    public void removeRow(String key) {
        this.getModel().removeRow(key);
        this.getEditorInput().removeRow(key);
        this.fireDirtyPropertyChanged();
    }

    public StringEditorViewerModel getModel() {
        return (StringEditorViewerModel)this.getEditorViewer().getInput();
    }

    public void dispose() {
        this.getEditorInput().removeInputChangeListener(this.inputChangeListener);
        this.getEditorInput().dispose();
        super.dispose();
    }

    public void fireDirtyPropertyChanged() {
        this.firePropertyChange(257);
    }

    public boolean getHighlightChanges() {
        return this.highlightChanges;
    }

    public String getSearchText() {
        return this.searchString;
    }

    public boolean getShowCellComments() {
        return this.showCellComments;
    }

    public String getKeyFilter() {
        return this.filterByKeyString;
    }

    private void executeOperation(EditorOperation operation) {
        try {
            operation.addContext(this.getUndoContext());
            this.getOperationHistory().execute((IUndoableOperation)operation, this.getProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            BasePlugin.logError((String)("Error executing editor operation: " + operation.getLabel()), (Throwable)e);
        }
    }

    public void setEditorStatus(IStatus status) {
        StringBuilder builder = new StringBuilder();
        int messageType = 0;
        if (status != null && !status.isOK()) {
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    builder.append(child.getMessage());
                    builder.append("\n");
                    ++n2;
                }
            } else {
                builder.append(status.getMessage());
            }
            switch (status.getSeverity()) {
                case 2: {
                    messageType = 2;
                    break;
                }
                case 4: {
                    messageType = 3;
                    break;
                }
            }
            this.editorComposite.setMessage(builder.toString(), messageType);
        } else {
            this.editorComposite.setMessage(null);
        }
    }

    public TableColumn getColumnByID(String columnID) {
        TableColumn theColumn = null;
        TableColumn[] tableColumnArray = this.getEditorViewer().getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (column.getText().equals(columnID)) {
                theColumn = column;
            }
            ++n2;
        }
        return theColumn;
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public Image getWarningImage() {
        return this.warningImage;
    }

    public Image getOKImage() {
        return this.okImage;
    }

    class AddColumnAction
    extends Action {
        public AddColumnAction() {
            super(Messages.StringEditorPart_AddColumnActionName);
        }

        public void run() {
            ColumnInfo info = StringEditorPart.this.getContentProvider().getOperationProvider().getNewColumn();
            if (info != null) {
                if (StringEditorPart.this.getColumnByID(info.getId()) == null) {
                    AddColumnOperation operation = new AddColumnOperation(Messages.StringEditorPart_AddColumnOperationName, StringEditorPart.this, info);
                    StringEditorPart.this.executeOperation(operation);
                } else {
                    MessageDialog.openInformation((Shell)StringEditorPart.this.getEditorSite().getShell(), (String)Messages.StringEditorPart_ColumnAlreadyExistTitle, (String)NLS.bind((String)Messages.StringEditorPart_ColumnAlreadyExistMessage, (Object)info.getId()));
                }
            }
        }
    }

    class AddKeyAction
    extends Action {
        public AddKeyAction() {
            super(Messages.StringEditorPart_AddKeyActionName);
        }

        public void run() {
            RowInfo info = StringEditorPart.this.getContentProvider().getOperationProvider().getNewRow();
            if (info != null) {
                if (StringEditorPart.this.getModel().getRow(info.getKey()) == null) {
                    AddKeyOperation operation = new AddKeyOperation(Messages.StringEditorPart_AddKeyOperationName, StringEditorPart.this, info);
                    operation.addContext(StringEditorPart.this.getUndoContext());
                    StringEditorPart.this.executeOperation(operation);
                } else {
                    StringEditorPart.this.editorComposite.setMessage(Messages.StringEditorPart_KeyAlreadyExistsErrorMessage, 3);
                }
            }
        }
    }

    class CellEditingSupport
    extends EditingSupport {
        private final String columnID;
        private final CellEditor editor;

        public CellEditingSupport(TableViewer viewer, String columnID) {
            super((ColumnViewer)viewer);
            this.columnID = columnID;
            this.editor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return !this.columnID.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            CellInfo info = ((RowInfo)element).getCells().get(this.columnID);
            return info != null && info.getValue() != null ? info.getValue() : "";
        }

        protected void setValue(Object element, Object value) {
            RowInfo theRow = (RowInfo)element;
            CellInfo oldCell = theRow.getCells().get(this.columnID);
            CellInfo newCell = null;
            if (value.toString().length() > 0) {
                if (oldCell != null) {
                    if (oldCell.getValue() != null && !oldCell.getValue().equals(value.toString()) || oldCell.getValue() == null) {
                        newCell = new CellInfo(value.toString(), oldCell.getComment());
                    }
                } else {
                    newCell = new CellInfo(value.toString(), null);
                }
            } else if (oldCell != null) {
                newCell = new CellInfo(null, null);
            }
            if (newCell != null) {
                newCell.setDirty(true);
                EditCellOperation operation = new EditCellOperation(theRow.getKey(), this.columnID, oldCell, newCell, StringEditorPart.this);
                StringEditorPart.this.executeOperation(operation);
            }
        }
    }

    class ColumnSelectionListener
    implements SelectionListener {
        private final TableViewer viewer;

        public ColumnSelectionListener(TableViewer theViewer) {
            this.viewer = theViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.widget;
            this.viewer.getTable().setSortColumn(column);
            this.viewer.getTable().setSortDirection(this.viewer.getTable().getSortDirection() == 1024 ? 128 : 1024);
            this.viewer.refresh();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class FilterByKeyTextModifyListener
    implements ModifyListener {
        FilterByKeyTextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            StringEditorPart.this.filterByKeyString = ((Text)e.widget).getText();
        }
    }

    class HideShowAllColumnsAction
    extends Action {
        private final Table table;
        private final boolean visible;

        public HideShowAllColumnsAction(String name, int style, Table t, boolean visible) {
            super(name, style);
            this.table = t;
            this.visible = visible;
        }

        public void run() {
            int i = 1;
            while (i < this.table.getColumnCount()) {
                if (this.visible) {
                    StringEditorPart.this.showColumn(this.table.getColumn(i));
                } else {
                    StringEditorPart.this.hideColumn(this.table.getColumn(i));
                }
                ++i;
            }
        }
    }

    class HideShowColumnAction
    extends Action {
        private final TableColumn column;

        public HideShowColumnAction(String name, int style, TableColumn c) {
            super(name, style);
            this.column = c;
            this.setChecked(c.getWidth() > 0);
        }

        public void run() {
            if (!this.isChecked()) {
                StringEditorPart.this.hideColumn(this.column);
            } else {
                StringEditorPart.this.showColumn(this.column);
            }
        }
    }

    class RemoveColumnAction
    extends Action {
        public RemoveColumnAction() {
            super(Messages.StringEditorPart_RemoveColumnActionName);
            String activeColumnID = StringEditorPart.this.getEditorViewer().getTable().getColumn(StringEditorPart.this.activeColumn).getText();
            this.setEnabled(StringEditorPart.this.activeColumn != 0 && StringEditorPart.this.getModel().getColumn(activeColumnID) != null && StringEditorPart.this.getModel().getColumn(activeColumnID).canRemove());
        }

        public void run() {
            TableColumn selectedColumn = StringEditorPart.this.getEditorViewer().getTable().getColumn(StringEditorPart.this.activeColumn);
            if (!selectedColumn.getText().equals(Messages.StringEditorPart_KeyLabel) && MessageDialog.openQuestion((Shell)StringEditorPart.this.getEditorSite().getShell(), (String)Messages.StringEditorPart_RemoveColumnActionName, (String)(String.valueOf(Messages.StringEditorPart_RemoveColumnQuestionMessage) + " \"" + selectedColumn.getText() + "\"?"))) {
                RemoveColumnOperation operation = new RemoveColumnOperation(Messages.StringEditorPart_RemoveColumnOperationName, StringEditorPart.this, ((StringEditorViewerModel)StringEditorPart.this.getEditorViewer().getInput()).getColumn(selectedColumn.getText()), StringEditorPart.this.getEditorViewer().getTable().indexOf(selectedColumn), selectedColumn.getWidth());
                StringEditorPart.this.executeOperation(operation);
            }
        }
    }

    class RemoveKeyAction
    extends Action {
        public RemoveKeyAction() {
            super(Messages.StringEditorPart_RemoveKeyActionName);
        }

        public void run() {
            ISelection sel = StringEditorPart.this.viewer.getSelection();
            ArrayList<RowInfo> toBeDeleted = new ArrayList<RowInfo>();
            if (sel != null && sel instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)sel;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof RowInfo) {
                        toBeDeleted.add((RowInfo)o);
                    }
                    ++n2;
                }
            }
            if (toBeDeleted.size() > 0) {
                RemoveKeyOperation operation = new RemoveKeyOperation(Messages.StringEditorPart_RemoveKeyOperationName, StringEditorPart.this, toBeDeleted);
                StringEditorPart.this.executeOperation(operation);
            }
        }
    }

    class RevertToSavedAction
    extends Action {
        public RevertToSavedAction() {
            super(Messages.StringEditorPart_RevertColumnActionName);
            this.setToolTipText(Messages.StringEditorPart_RevertColumnActionTooltip);
            this.setEnabled(StringEditorPart.this.activeColumn != 0);
        }

        public void run() {
            String column = StringEditorPart.this.viewer.getTable().getColumn(StringEditorPart.this.activeColumn).getText();
            RevertColumnToSavedStateOperation operation = new RevertColumnToSavedStateOperation(Messages.StringEditorPart_RevertColumnActionOperationName, StringEditorPart.this, StringEditorPart.this.getModel().getColumn(column));
            StringEditorPart.this.executeOperation(operation);
        }
    }

    class SearchTextModifyListener
    implements ModifyListener {
        SearchTextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            StringEditorPart.this.searchString = ((Text)e.widget).getText();
            StringEditorPart.this.updateViewer(null);
        }
    }

    class TranslateColumnAction
    extends Action {
        public TranslateColumnAction() {
            super(Messages.StringEditorPart_TranslateActionName);
            this.setEnabled(StringEditorPart.this.activeColumn != 0);
        }

        public void run() {
            TableColumn column = StringEditorPart.this.getEditorViewer().getTable().getColumn(StringEditorPart.this.activeColumn);
            ColumnInfo newColumnInfo = StringEditorPart.this.getContentProvider().getOperationProvider().getNewColumn();
            if (newColumnInfo != null) {
                TranslateOperation operation = new TranslateOperation(StringEditorPart.this, column.getText(), newColumnInfo);
                StringEditorPart.this.executeOperation(operation);
            }
        }
    }
}

