/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.localization.stringeditor.datatype.RowInfo;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorPart;

public class StringEditorViewerEditableTooltipSupport
extends ColumnViewerToolTipSupport {
    private String tooltipText;
    private final ColumnViewer viewer;
    private Event currentTooltipEvent;
    private final StringEditorPart editor;

    protected StringEditorViewerEditableTooltipSupport(ColumnViewer viewer, int style, boolean manualActivation, StringEditorPart editor) {
        super(viewer, style, manualActivation);
        this.setHideDelay(0);
        this.setHideOnMouseDown(false);
        this.setPopupDelay(100);
        this.setShift(new Point(-3, 0));
        this.tooltipText = null;
        this.viewer = viewer;
        this.editor = editor;
    }

    public static void enableFor(ColumnViewer viewer, int style, StringEditorPart editor) {
        new StringEditorViewerEditableTooltipSupport(viewer, style, false, editor);
    }

    protected Composite createViewerToolTipContentArea(Event event, ViewerCell cell, Composite parent) {
        Composite toReturn = null;
        if (cell.getColumnIndex() != 0) {
            final String text = this.getText(event);
            toReturn = new Composite(parent, 4);
            GridLayout layout = new GridLayout();
            toReturn.setLayout((Layout)layout);
            final Text textComposite = new Text(toReturn, 66);
            GridData layouData = new GridData(1808);
            layouData.minimumWidth = 200;
            layouData.minimumHeight = 50;
            layouData.grabExcessHorizontalSpace = true;
            layouData.grabExcessVerticalSpace = true;
            textComposite.setText(text.trim().length() > 0 ? text : "Type your comment here");
            textComposite.setLayoutData((Object)layouData);
            textComposite.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringEditorViewerEditableTooltipSupport.this.tooltipText = ((Text)e.widget).getText();
                }
            });
            textComposite.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    if (text.trim().length() == 0) {
                        textComposite.setText("");
                        StringEditorViewerEditableTooltipSupport.this.tooltipText = null;
                    }
                }
            });
        } else {
            toReturn = super.createViewerToolTipContentArea(event, cell, parent);
        }
        this.currentTooltipEvent = event;
        return toReturn;
    }

    protected void afterHideToolTip(Event event) {
        ViewerCell cell = this.viewer.getCell(new Point(this.currentTooltipEvent.x, this.currentTooltipEvent.y));
        if (cell.getColumnIndex() != 0) {
            RowInfo row = (RowInfo)cell.getViewerRow().getElement();
            TableColumn column = ((Table)this.viewer.getControl()).getColumn(cell.getColumnIndex());
            if (this.tooltipText != null && !this.tooltipText.trim().equals(row.getCells().get(column.getText()).getComment())) {
                row.getCells().get(column.getText()).setComment(this.tooltipText.trim());
                if (this.editor != null) {
                    try {
                        this.editor.getEditorInput().setCellTooltip(column.getText(), row.getKey(), this.tooltipText);
                        this.editor.fireDirtyPropertyChanged();
                    }
                    catch (TmLException e) {
                        BasePlugin.logError((String)("Error setting cell tooltip: (" + column.getText() + ", " + row.getKey() + ") = " + this.tooltipText), (Throwable)e);
                    }
                }
            }
            this.tooltipText = null;
            this.currentTooltipEvent = null;
        }
        super.afterHideToolTip(event);
    }
}

