/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tml.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.tml.localization.stringeditor.editor.operations.EditorOperation;

public class RemoveColumnOperation
extends EditorOperation {
    private final ColumnInfo column;
    private final int columnIndex;
    private final int columnWidth;
    boolean changedColumn = false;

    public RemoveColumnOperation(String label, StringEditorPart editor, ColumnInfo column, int columnIndex, int columnWidth) {
        super(label, editor);
        this.column = column;
        this.columnIndex = columnIndex;
        this.columnWidth = columnWidth;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.redo(monitor, info);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getEditor().removeColumn(this.column.getId());
        this.changedColumn = this.getEditor().unmarkColumnAsChanged(this.column.getId());
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getEditor().addColumn(this.column, this.columnIndex).setWidth(this.columnWidth);
        if (this.changedColumn) {
            this.getEditor().markColumnAsChanged(this.column.getId());
        }
        return Status.OK_STATUS;
    }
}

